/*
 *  Energy_fit_4d.cpp
 *  SimAnn
 *
 *  Created by Patrick Hillenbrand on 5/3/12.
 *  Copyright 2012 __MyCompanyName__. All rights reserved.
 *
 */

#include "Energy_fit_4d.h"
#include <math.h>
#include <stdexcept>

/**********************************************************************************************************************
 *********** class Energy_fit_4d implementation ***********************************************************************
 **********************************************************************************************************************/

Energy_fit_4d::Energy_fit_4d(int logic1, int logic2, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector< std::vector<double> > p_t1, std::vector< std::vector<double> > p_t2, std::vector< std::vector<double> > p_t3, std::vector< std::vector<double> > p_t4)
{
	m_logic1 = logic1;
    m_logic2 = logic2;
	m_N = 4;
	m_LB = LB;
	m_UB = UB;
	trgs = trg_syn;
	pt1 = p_t1;
	pt2 = p_t2;
	pt3 = p_t3;
    pt4 = p_t4;
	int Ngrid = 10000;
	fac1 = ((double)Ngrid)/(m_UB[0]-m_LB[0]);
	fac2 = ((double)Ngrid)/(m_UB[1]-m_LB[1]);
	fac3 = ((double)Ngrid)/(m_UB[2]-m_LB[2]);
    fac4 = ((double)Ngrid)/(m_UB[3]-m_LB[3]);
}

/**********************************************************************************************************************/

Energy_fit_4d::~Energy_fit_4d() {}

/**********************************************************************************************************************/

double Energy_fit_4d::Energy (double *par)
{
	double res = 0.;
	
    if (pt1.size() == 1) ind1 = 0;
    else ind1 = floor((par[0]-m_LB[0])*fac1);
    pit1 = pt1[ind1].begin();
    
    if (pt2.size() == 1) ind2 = 0;
    else ind2 = floor((par[1]-m_LB[1])*fac2);
    pit2 = pt2[ind2].begin();
    
    if (pt3.size() == 1) ind3 = 0;
    else ind3 = floor((par[2]-m_LB[2])*fac3);
    pit3 = pt3[ind3].begin();
    
    if (pt4.size() == 1) ind4 = 0;
    else ind4 = floor((par[3]-m_LB[3])*fac4);
    pit4 = pt4[ind4].begin();
    
    sit = trgs.begin();
    
    b = par[4];
    a = par[5];
    K1 = par[6];
    n1 = par[10];
    K1 = pow(K1,n1);
    K2 = par[7];
    n2 = par[11];
    K2 = pow(K2,n2);
    K3 = par[8];
    n3 = par[12];
    K3 = pow(K3,n3);
    K4 = par[9];
    n4 = par[13];
    K4 = pow(K4,n4);
    
    for (i = 0; i < 42; i++) {
        ////////////////////////////////////// LOGIC1
        if (m_logic1 == 1) { // A AND B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))*(tmp2/(tmp2+K2));
        } else if (m_logic1 == 2) { // A AND NOT B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))*(K2/(tmp2+K2));
        } else if (m_logic1 == 3) { // NOT A AND B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (K1/(tmp1+K1))*(tmp2/(tmp2+K2));
        } else if (m_logic1 == 4) { // A XOR B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(K1/(tmp1+K1))*(tmp2/(tmp2+K2));
        } else if (m_logic1 == 5) { // A OR B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))+(tmp2/(tmp2+K2));
        } else if (m_logic1 == 6) { // A NOR B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (K1/(tmp1+K1))*(K2/(tmp2+K2));
        } else if (m_logic1 == 7) { // A OR NOT B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))+(K2/(tmp2+K2));
        } else if (m_logic1 == 8) { // NOT A OR B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (K1/(tmp1+K1))+(tmp2/(tmp2+K2));
        } else if (m_logic1 == 9) { // A NAND B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (K1/(tmp1+K1))+(K2/(tmp2+K2));
        } else if (m_logic1 == 10) { // A EQ B
            tmp1 = pow(*pit1,n1);
            tmp2 = pow(*pit2,n2);
            tmp = (tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K1/(tmp1+K1))*(K2/(tmp2+K2));
        } else if (m_logic1 == 11) { // A
            tmp1 = pow(*pit1,n1);
            tmp = (tmp1/(tmp1+K1));
        } else if (m_logic1 == 12) { // NOT A
            tmp1 = pow(*pit1,n1);
            tmp = (K1/(tmp1+K1));
        } else if (m_logic1 == 13) { // B
            tmp2 = pow(*pit2,n2);
            tmp = (tmp2/(tmp2+K2));
        } else if (m_logic1 == 14) { // NOT B
            tmp2 = pow(*pit2,n2);
            tmp = (K2/(tmp2+K2));
        } else {
            throw std::runtime_error("invalid logic.");
        }
        
        ////////////////////////////////////// LOGIC2
        if (m_logic2 == 1) { // A AND B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))*(tmp4/(tmp4+K4));
        } else if (m_logic2 == 2) { // A AND NOT B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))*(K4/(tmp4+K4));
        } else if (m_logic2 == 3) { // NOT A AND B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (K3/(tmp3+K3))*(tmp4/(tmp4+K4));
        } else if (m_logic2 == 4) { // A XOR B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))*(K4/(tmp4+K4))+(K3/(tmp3+K3))*(tmp4/(tmp4+K4));
        } else if (m_logic2 == 5) { // A OR B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))+(tmp4/(tmp4+K4));
        } else if (m_logic2 == 6) { // A NOR B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (K3/(tmp3+K3))*(K4/(tmp4+K4));
        } else if (m_logic2 == 7) { // A OR NOT B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))+(K4/(tmp4+K4));
        } else if (m_logic2 == 8) { // NOT A OR B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (K3/(tmp3+K3))+(tmp4/(tmp4+K4));
        } else if (m_logic2 == 9) { // A NAND B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (K3/(tmp3+K3))+(K4/(tmp4+K4));
        } else if (m_logic2 == 10) { // A EQ B
            tmp3 = pow(*pit3,n3);
            tmp4 = pow(*pit4,n4);
            tmp += (tmp3/(tmp3+K3))*(tmp4/(tmp4+K4))+(K3/(tmp3+K3))*(K4/(tmp4+K4));
        } else if (m_logic2 == 11) { // A
            tmp3 = pow(*pit3,n3);
            tmp += (tmp3/(tmp3+K3));
        } else if (m_logic2 == 12) { // NOT A
            tmp3 = pow(*pit3,n3);
            tmp += (K3/(tmp3+K3));
        } else if (m_logic2 == 13) { // B
            tmp4 = pow(*pit4,n4);
            tmp += (tmp4/(tmp4+K4));
        } else if (m_logic2 == 14) { // NOT B
            tmp4 = pow(*pit4,n4);
            tmp += (K4/(tmp4+K4));
        } else {
            throw std::runtime_error("invalid logic.");
        }
        
        tmp = b + a*tmp;
        res += pow(tmp-(*sit),2);
        pit1++; pit2++; pit3++; pit4++; sit++;
    }
	
	return res;
}

/**********************************************************************************************************************/

unsigned int Energy_fit_4d::GetN ()
{
	return 14;
}

/**********************************************************************************************************************/

double* Energy_fit_4d::GetLB ()
{
	return &m_LB[0];
}

/**********************************************************************************************************************/

double* Energy_fit_4d::GetUB ()
{
	return &m_UB[0];
}
