/*
 *  Energy_fit_4d.h
 *  SimAnn
 *
 *  Created by Patrick Hillenbrand on 5/3/12.
 *  Copyright 2012 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef _ENERGY_FIT_4D_
#define _ENERGY_FIT_4D_

#include <vector>

#include "LamSimAnn.h"


class Energy_fit_4d: public Energy_base
{
	
public:
	// contructor / destructor
	explicit Energy_fit_4d(int logic1, int logic2, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector< std::vector<double> > p_t1, std::vector< std::vector<double> > p_t2, std::vector< std::vector<double> > p_t3, std::vector< std::vector<double> > p_t4);
	~Energy_fit_4d();
	
	// interface
	virtual double Energy (double *par);
	virtual unsigned int GetN ();
	virtual double* GetLB ();
	virtual double* GetUB ();
	
	//data
private:
	unsigned int m_N;
	int m_logic1; int m_logic2;
	std::vector<double> m_LB;
	std::vector<double> m_UB;
	
	std::vector<double> trgs;
		
	std::vector< std::vector<double> > pt1;
	std::vector< std::vector<double> > pt2;
	std::vector< std::vector<double> > pt3;
    std::vector< std::vector<double> > pt4;
	
	int i;
	int ind1,ind2,ind3,ind4;
	double fac1,fac2,fac3,fac4;
	std::vector<double>::iterator pit1,pit2,pit3,pit4,sit;
	double a,b,K1,K2,K3,K4,n1,n2,n3,n4;
	double tmp,tmp1,tmp2,tmp3,tmp4;
	
	// auxiliary functions
	
};

#endif