//
//  Energy_fit_lambda.cpp
//  SimAnn
//
//  Created by Patrick Hillenbrand on 18.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#include <iostream>
#include <vector>
#include "Energy_fit_lambda.h"
#include "LamSimAnn.h"


/**********************************************************************************************************************
 *********** class Energy_fit_lambda implementation **************************************************************************
 **********************************************************************************************************************/

Energy_fit_lambda::Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector<double> p_t1)
{
	m_logic = logic;
	m_N = 1;
	m_LB = LB;
	m_UB = UB;
	trgs = trg_syn;
	pt1 = p_t1;
    Nts = trgs.size();
}

/**********************************************************************************************************************/

Energy_fit_lambda::Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector<double> p_t1, std::vector<double> p_t2)
{
	m_logic = logic;
	m_N = 2;
	m_LB = LB;
	m_UB = UB;
	trgs = trg_syn;
	pt1 = p_t1;
	pt2 = p_t2;
    Nts = trgs.size();
}

/**********************************************************************************************************************/

Energy_fit_lambda::Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB,std::vector<double> p_t1, std::vector<double> p_t2, std::vector<double> p_t3)
{
	m_logic = logic;
	m_N = 3;
	m_LB = LB;
	m_UB = UB;
	trgs = trg_syn;
	pt1 = p_t1;
	pt2 = p_t2;
	pt3 = p_t3;
    Nts = trgs.size();
}

/**********************************************************************************************************************/

Energy_fit_lambda::~Energy_fit_lambda() {}

/**********************************************************************************************************************/

double Energy_fit_lambda::Energy (double *par)
{
	double res = 0.;
	
	if (m_N == 1) {
        
        pit1 = pt1.begin();
		sit = trgs.begin();
		
		b = par[0];
		a = par[1];
		K1 = par[2];
		n1 = par[3];
		K1 = pow(K1,n1);
		
		if (m_logic == 1) {
			for (i=0; i<Nts; i++) {
				tmp = pow(*pit1,n1);
				tmp = b+a*(tmp/(tmp+K1));
				res += pow(tmp-(*sit),2);
				pit1++;
				sit++;
			}
		} else if (m_logic == 2) {
			for (i=0; i<Nts; i++) {
				tmp = pow(*pit1,n1);
				tmp = b+a*(K1/(tmp+K1));
				res += pow(tmp-(*sit),2);
				pit1++;
				sit++;
			}
		}
        
	} else if (m_N == 2) {
        
        pit1 = pt1.begin();
        pit2 = pt2.begin();
		sit = trgs.begin();
		
		b = par[0];
		a = par[1];
		K1 = par[2];
		n1 = par[4];
		K1 = pow(K1,n1);
		K2 = par[3];
		n2 = par[5];
		K2 = pow(K2,n2);
		
		if (m_logic == 1) { // A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(tmp1/(tmp1+K1))*(tmp2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 2) { // A AND NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(tmp1/(tmp1+K1))*(K2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 3) { // NOT A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(K1/(tmp1+K1))*(tmp2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 4) { // A XOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(K1/(tmp1+K1))*(tmp2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 5) { // A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((tmp1/(tmp1+K1))+(tmp2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 6) { // A NOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(K1/(tmp1+K1))*(K2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 7) { // A OR NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((tmp1/(tmp1+K1))+(K2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 8) { // NOT A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((K1/(tmp1+K1))+(tmp2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 9) { // A NAND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((K1/(tmp1+K1))+(K2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 10) { // A EQ B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp = b+a*((tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K1/(tmp1+K1))*(K2/(tmp2+K2)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 11) { // A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp = b+a*(tmp1/(tmp1+K1));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 12) { // NOT A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp = b+a*(K1/(tmp1+K1));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 13) { // B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(tmp2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} else if (m_logic == 14) { // NOT B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp = b+a*(K2/(tmp2+K2));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; sit++;
			}
		} 
        
	} else if (m_N == 3) {
        
        pit1 = pt1.begin();
        pit2 = pt2.begin();
        pit3 = pt3.begin();
		sit = trgs.begin();
		
		b = par[0];
		a = par[1];
		K1 = par[2];
		n1 = par[5];
		K1 = pow(K1,n1);
		K2 = par[3];
		n2 = par[6];
		K2 = pow(K2,n2);
		K3 = par[4];
		n3 = par[7];
		K3 = pow(K2,n3);
		
		////////////////////////////////////// ADDITIONAL ACTIVATOR
		if (m_logic == 1) { // A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 2) { // A AND NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 3) { // NOT A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))*(tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 4) { // A XOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(K1/(tmp1+K1))*(tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 5) { // A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 6) { // A NOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))*(K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 7) { // A OR NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 8) { // NOT A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 9) { // A NAND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 10) { // A EQ B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K1/(tmp1+K1))*(K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 11) { // A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 12) { // NOT A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 13) { // B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 14) { // NOT B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K2/(tmp2+K2))+(tmp3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
			//////////////////////////////////////// ADDITIONAL REPRESSOR
		} else if (m_logic == 15) { // A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 16) { // A AND NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 17) { // NOT A AND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 18) { // A XOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(K2/(tmp2+K2))+(K1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 19) { // A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 20) { // A NOR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))*(K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 21) { // A OR NOT B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 22) { // NOT A OR B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 23) { // A NAND B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 24) { // A EQ B
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))*(tmp2/(tmp2+K2))+(K1/(tmp1+K1))*(K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 25) { // A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp1/(tmp1+K1))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 26) { // NOT A
			for (i=0; i<Nts; i++) {
				tmp1 = pow(*pit1,n1);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K1/(tmp1+K1))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 27) { // B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((tmp2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} else if (m_logic == 28) { // NOT B
			for (i=0; i<Nts; i++) {
				tmp2 = pow(*pit2,n2);
				tmp3 = pow(*pit3,n3);
				tmp = b+a*((K2/(tmp2+K2))+(K3/(tmp3+K3)));
				res += pow(tmp-(*sit),2);
				pit1++; pit2++; pit3++; sit++;
			}
		} 
        
	}
	
	return res;
}

/**********************************************************************************************************************/

unsigned int Energy_fit_lambda::GetN ()
{
	if (m_N == 1) return 4;
	else if (m_N == 2) return 6;
	else if (m_N == 3) return 8;
	else return 0;
}

/**********************************************************************************************************************/

double* Energy_fit_lambda::GetLB ()
{
	return &m_LB[0];
}

/**********************************************************************************************************************/

double* Energy_fit_lambda::GetUB ()
{
	return &m_UB[0];
}