//
//  Energy_fit_lambda.h
//  SimAnn
//
//  Created by Patrick Hillenbrand on 18.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#ifndef SimAnn_Energy_fit_lambda_h
#define SimAnn_Energy_fit_lambda_h

#include <vector>

#include "LamSimAnn.h"


class Energy_fit_lambda: public Energy_base
{
	
public:
	// contructor / destructor
	explicit Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector<double> p_t1);
	explicit Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector<double> p_t1, std::vector<double> p_t2);
	explicit Energy_fit_lambda(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector<double> p_t1, std::vector<double> p_t2, std::vector<double> p_t3);
	~Energy_fit_lambda();
	
	// interace
	virtual double Energy (double *par);
	virtual unsigned int GetN ();
	virtual double* GetLB ();
	virtual double* GetUB ();
	
	//data
private:
    unsigned int Nts;
	unsigned int m_N;
	int m_logic;
	std::vector<double> m_LB;
	std::vector<double> m_UB;
	
	std::vector<double> trgs;
    
	std::vector<double> pt1;
	std::vector<double> pt2;
	std::vector<double> pt3;
	
	int i;
	std::vector<double>::iterator pit1,pit2,pit3,sit;
	double a,b,K1,K2,K3,n1,n2,n3;
	double tmp,tmp1,tmp2,tmp3;
	
	// auxiliary functions
	
};

#endif
