/*
 *  LamSimAnn.h
 *  SimAnn
 *
 *  Created by Patrick Hillenbrand on 5/1/12.
 *  Copyright 2012 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef _LAMSIMANN_
#define _LAMSIMANN_

#include <vector>
#include "boost/random.hpp"

/**********************************************************************************************************************
*********** base class for energy function ****************************************************************************
**********************************************************************************************************************/

class Energy_base // derive your fitness class from this template
{
public:
	virtual double Energy (double *par) = 0; // return fitness value (being minimized)
	virtual unsigned int GetN () = 0; // return number of parameters
	virtual double* GetLB () = 0; // return lower boundaries of parameters
	virtual double* GetUB () = 0; // return upper boundaries of parameters
};

/**********************************************************************************************************************
*********** class simulated annealing *********************************************************************************
**********************************************************************************************************************/

class LamSimAnn
{

public:
	// constructor / destructor
	explicit LamSimAnn (double lambda=0.0001, unsigned int tau=100, double theta_m_0=0.1, double frozen_N=10, double frozen_eps=10e-10);
	virtual ~LamSimAnn ();
	
	// interface
	void Run (Energy_base *loss_fct, double *start_par=NULL);
	
	std::vector<double> GetBestPar() {return best_par;}
	double GetBestEnergy () {return best_energy;}
	std::vector<double> GetAccRatioHist() {return acc_ratio_hist;}
	std::vector<double> GetMeanEnergyHist() {return mean_energy_hist;}
	std::vector<double> GetTHist() {return temperature_hist;}
	
	// data
private:
	// metaparameters
	unsigned int N;
	double m_lambda, m_K, m_theta_m_0;
	unsigned int m_tau;
    int m_frozen_N;
    double m_frozen_eps;
	double *m_LB, *m_UB;
	
	double w_a, w_b;
	
	// random number generator
	boost::mt19937 m_mt;
	boost::variate_generator< boost::mt19937& , boost::uniform_real<> > *m_rng;
	
	// auxiliary variables needed in member functions
	int i,l,k;
	int frozen_cnt;
	double rnd, rnd1, rnd2;
	Energy_base *m_anchor;
	
	// algorithm variables
	double current_energy;
	double m_mean, m_vari;
	std::vector<double> current_par;
	double proposed_par;
	std::vector<double> tmp_par;
	std::vector<double> m_theta;
	std::vector<double> acc_ratio;
	
	// Temperature and associated variables
	double S,dS;
	double estimate_mean, estimate_std;
	double A,B,D,E;
	
	double usxx,usyy,usxy,usx,usy,usum;
	double vsxx,vsyy,vsxy,vsx,vsy,vsum;
	double alpha;
	
	// results
	double best_energy;
	std::vector<double> best_par;
	std::vector<double> mean_energy_hist;
	std::vector<double> acc_ratio_hist;
	std::vector<double> temperature_hist;
	
	// auxiliary functions
private:
	double make_move(int par_n);
	void update_S();
	void update_parameter();
	void initialize_parameter();
	void update_control();
	bool is_frozen();

};

#endif