//
//  NetworkFinder.h
//  IrreducibleNetworks
//
//  Created by Patrick Hillenbrand on 17.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#ifndef IrreducibleNetworks_NetworkFinder_h
#define IrreducibleNetworks_NetworkFinder_h

#include <vector>


struct Node
{
    int trg;
    int node_id;
    std::vector<int> tfs;
    double score;
};



class NetworkFinder
{
public:
    NetworkFinder (std::vector< std::vector<int> > imat_);
    ~NetworkFinder () {}
    
    long FindAll (int nb);
    long GetNN () {return m_nn;}
    long GetN () {return m_N;}
    std::vector<double> GetNetScores() {return net_scores;}
    
    void AddNode (Node node);
    void ScoreNetworks ();
    
    std::vector< std::vector<Node> > GetBestNetworks (int howmany);

private:
    long m_N;
    long m_nn;
    double low_end;
    std::vector<Node> curr_netw;
    std::vector<int> nodes;
    std::vector<int> in_netw;
    std::vector< std::vector<int> > imat;
    
    std::vector< std::vector<Node> > networks;
    std::vector<double> net_scores;
    std::vector<int> score_map;
    std::vector<Node> all_nodes;
    
private:
    int isConnected ();
    void ListNodes (int n);
    void ListNetworks (int n);
    void StoreNetw(int in);

};

////////////////////////////////////
// cmp operator for network nodes //
////////////////////////////////////

bool operator== (Node x, Node y);

#endif
