#include "mex.h"
#include "LamSimAnn.h"
#include "Energy_fit_4d.h"
#include <iostream>

//**************************************************************************************************************************************************

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
// @args: logic1, logic2, pt1, pt2, pt3, pt4, trg_syn, LB, UB
{
	mwSize r,c;
	int i,j;
	int logic1,logic2;
	std::vector< std::vector<double> > pt1,pt2,pt3,pt4;
	std::vector<double> lb,ub,trgs;
	double *p;
	
	if (nrhs < 9) mexErrMsgTxt("At least 9 arguments required.");

	logic1 = int(*mxGetPr(prhs[0]));
    logic2 = int(*mxGetPr(prhs[1]));
	
	r = mxGetM(prhs[2]);
	c = mxGetN(prhs[2]);
	pt1.resize(r);
	for (i=0; i<r; i++) pt1[i].resize(c);
	p = mxGetPr(prhs[2]);
	for (i=0; i<c; i++) {
		for (j=0; j<r; j++) {
			pt1[j][i] = *p;
			p++;
		}
	}
	
    r = mxGetM(prhs[3]);
	c = mxGetN(prhs[3]);
    pt2.resize(r);
    for (i=0; i<r; i++) pt2[i].resize(c);
    p = mxGetPr(prhs[3]);
    for (i=0; i<c; i++) {
        for (j=0; j<r; j++) {
            pt2[j][i] = *p;
            p++;
        }
    }
	
    r = mxGetM(prhs[4]);
	c = mxGetN(prhs[4]);
	pt3.resize(r);
    for (i=0; i<r; i++) pt3[i].resize(c);
    p = mxGetPr(prhs[4]);
    for (i=0; i<c; i++) {
        for (j=0; j<r; j++) {
            pt3[j][i] = *p;
            p++;
        }
    }
    
    r = mxGetM(prhs[5]);
	c = mxGetN(prhs[5]);
    pt4.resize(r);
    for (i=0; i<r; i++) pt4[i].resize(c);
    p = mxGetPr(prhs[5]);
    for (i=0; i<c; i++) {
        for (j=0; j<r; j++) {
            pt4[j][i] = *p;
            p++;
        }
    }
	
	r = mxGetM(prhs[6]);
	c = mxGetN(prhs[6]);
	trgs.resize(c);
	p = mxGetPr(prhs[6]);
	for (i=0; i<c; i++) {
		trgs[i] = *p;
		p++;
	}
	
	r = mxGetM(prhs[7]);
	c = mxGetN(prhs[7]);
	lb.resize(c);
	p = mxGetPr(prhs[7]);
	for (i=0; i<c; i++) {
		lb[i] = *p;
		p++;
	}
	
	r = mxGetM(prhs[8]);
	c = mxGetN(prhs[8]);
	ub.resize(c);
	p = mxGetPr(prhs[8]);
	for (i=0; i<c; i++) {
		ub[i] = *p;
		p++;
	}

	double lam=0.0005,theta=0.1;
	int tau=100;
	
	LamSimAnn sim(lam,tau,theta);
    
    Energy_fit_4d fct(logic1,logic2,trgs,lb,ub,pt1,pt2,pt3,pt4);
    
    sim.Run(&fct);
	
	std::vector<double> tmp = sim.GetBestPar();
	plhs[0] = mxCreateDoubleMatrix(1,tmp.size(), mxREAL);
	p = mxGetPr(plhs[0]);
	for (i=0; i<tmp.size(); i++) {
		*p = tmp[i];
		p++;
	}
	
	double tmp2 = sim.GetBestEnergy();
	plhs[1] = mxCreateDoubleMatrix(1,1, mxREAL);
	p = mxGetPr(plhs[1]);
	*p = tmp2;
	
	
}
