function p_t = protein_traj (mrna,t,p_0, lambdaP, alphaP)

if (isempty(p_0))
    p_0 = set_p0(mrna,lambdaP);
end

if (nargin==4)
    alphaP = lambdaP;
end

points = 3;
n = length(t)*points;

tINT = linspace(0,t(length(t)),n);

mINT = interp1(t,mrna,tINT,'linear');

LONGintegral = zeros(1,n);

f = 0.5*(tINT(2)-tINT(1));

for i=2:length(LONGintegral)
    
    LONGintegral(i) = f*sum( (mINT(2:i).*exp(lambdaP*(tINT(2:i)-tINT(i)))) + (mINT(1:(i-1)).*exp(lambdaP*(tINT(1:(i-1))-tINT(i)))) );

end

p_t = (exp(-lambdaP.*t) .*p_0) + alphaP * LONGintegral(1:points:n);

%  md = (1/(t(2)-t(1)))*(mrna(2:length(mrna))-mrna(1:(length(mrna)-1)));
%  %mint = (1/lambdaP) * ((mrna(1:(length(t)-1))-md/lambdaP+md.*t(2:length(t))).*exp(lambdaP*t(2:length(t)))-(mrna(1:(length(t)-1))-md/lambdaP+md.*t(1:(length(t)-1))).*exp(lambdaP*t(1:(length(t)-1))));
%  mint=[0 (mrna(1:(length(t)-1))-md/lambdaP+md.*t(2:length(t)))/lambdaP];
%  
%  LONGintegral = zeros(1,length(mrna));
%   
%   for i = 2:length(mrna)
%       LONGintegral(i) = sum(mint(2:i).*exp(lambdaP*(t(2:i)-t(i)))-mint(1:(i-1)).*exp(lambdaP*(t(1:(i-1))-t(i))));
%   end
%   
%   p_t = (exp(-lambdaP.*t) .*p_0) + alphaP * LONGintegral;