function [phist,lam_est] = Estimate_lambda (l,ns,plot_res)

[N,grid] = size(ns);

phist = ones(1,grid);

for i = 1:N
    phist = phist.*ns(i,:);
    phist = phist / sum(phist);
end

[m,mi] = max(phist);

if (numel(mi)>1)
    error('multiple modes in histogram, please run again.')
end

lam_est = l(mi);

if (nargin >= 3 && plot_res)
    figure('OuterPosition',[100 600 800 500]);
    bar(l,phist)
    axis([l(1),l(end),0,1.1*m]);
    xlabel('\lambda','FontSize',20);
    ylabel('combined likelihood','FontSize',16);
    title('Product Histogram','FontSize',20);
    hold on;
    plot([l(mi),l(mi)],[0,1.1*m],'r');
end
   