function fit = FitLamm (gene_id,rep)

global expr1;
global expr2;
global syn1;
global syn2;

% time
t = 0:5:205;

%data
if (rep==1)
    expr = expr1(gene_id,:);
    syn = syn1(gene_id,:);
elseif(rep==2)
    expr = expr2(gene_id,:);
    syn = syn2(gene_id,:);
elseif (rep==0)
    expr = 0.5*(expr1(gene_id,:)+expr2(gene_id,:));
    syn = 0.5*(syn1(gene_id,:)+syn2(gene_id,:));
else
    error('argument rep must be 0,1, or 2.');
end

% fill missing data
nans = isnan(syn);
if (sum(nans)~=0)
   if (sum(nans) >= length(nans)-3)
       error('at least three values of target synthesis rate must not be NaN!');
   end
   tt = zeros(1,numel(nans(nans==0)));
   xx = tt;
   j=1;
   for i = 1:length(nans)
      if (nans(i)==0)
          tt(j) = t(i);
          xx(j) = syn(i);
          j=j+1;
      end
   end
   syn = interp1(tt,xx,t,'spline');
end

nans = isnan(expr);
if (sum(nans)~=0)
   if (sum(nans) >= length(nans)-3)
       error('at least three values of target synthesis rate must not be NaN!');
   end
   tt = zeros(1,numel(nans(nans==0)));
   xx = tt;
   j=1;
   for i = 1:length(nans)
      if (nans(i)==0)
          tt(j) = t(i);
          xx(j) = expr(i);
          j=j+1;
      end
   end
   expr = interp1(tt,xx,t,'spline');
end

    function res = LammCost (l,e,s)
       res=0; 
       for k=2:42
           mm=e(k-1)*exp(-l*5)+(s(k)/l)*(1-exp(-l*5));
           res=res + (mm-e(k))^2;
       end
    end

fit = fminsearch(@(l)LammCost(l,expr,syn),1);

    function em = Lamm (l,e,s)
       em = zeros(1,42);
       em(1) = e(1);
       for k=2:42
           em(k)=em(k-1)*exp(-l*5)+(s(k)/l)*(1-exp(-l*5));
       end
    end

%em = Lamm(fit,expr,syn);
%figure; plot(t,expr);
%hold on;
%plot(t,em,'r');

end