function model = LearnGRF_4d (tf,trg,logic1,logic2,rep,p_t1,p_t2,p_t3,p_t4)

global expr1;
global expr2;
global syn1;
global syn2;

%data
if (rep==1)
    tf_expr1 = expr1(tf(1),:);
    tf_expr2 = expr1(tf(2),:);
    tf_expr3 = expr1(tf(3),:);
    tf_expr4 = expr1(tf(4),:);
    trg_syn = syn1(trg,:);
elseif(rep==2)
    tf_expr1 = expr2(tf(1),:);
    tf_expr2 = expr2(tf(2),:);
    tf_expr3 = expr2(tf(3),:);
    tf_expr4 = expr2(tf(4),:);
    trg_syn = syn2(trg,:);
else
    error('argument rep must be 0,1, or 2.');
end

% protein grids
lam = zeros(1,4);
t = 0:5:205;

[r c] = size(p_t1);
if (r == 1 && c == 1)
    lam(1) = p_t1;
    p_t1 = protein_traj(tf_expr1,t,[],p_t1);
end

[r c] = size(p_t2);
if (r == 1 && c == 1)
    lam(2) = p_t2;
    p_t2 = protein_traj(tf_expr2,t,[],p_t2);
end

[r c] = size(p_t3);
if (r == 1 && c == 1)
    lam(3) = p_t3;
    p_t3 = protein_traj(tf_expr3,t,[],p_t3);
end

[r c] = size(p_t4);
if (r == 1 && c == 1)
    lam(4) = p_t4;
    p_t4 = protein_traj(tf_expr4,t,[],p_t4);
end

% define boundaries
LB = zeros(1,14);
UB = LB;
LB(1) = log(2)/70; UB(1) = log(2)/5;                       % lp1
LB(2) = log(2)/70; UB(2) = log(2)/5;                       % lp2
LB(3) = log(2)/70; UB(3) = log(2)/5;                       % lp3
LB(4) = log(2)/70; UB(4) = log(2)/5;                       % lp4

LB(5) = 0; UB(5) = 2*max(trg_syn);                         % b
LB(6) = 0.01*(max(trg_syn)-min(trg_syn)); UB(6) = 2*(max(trg_syn)-min(trg_syn));      % a_max

LB(7) = 0; UB(7) = 100*max(tf_expr1);                      % K1
LB(8) = 0; UB(8) = 100*max(tf_expr2);                      % K2
LB(9) = 0; UB(9) = 100*max(tf_expr3);                      % K3
LB(10) = 0; UB(10) = 100*max(tf_expr4);                    % K4

LB(11) = 0; UB(11) = 30;                                   % n1
LB(12) = 0; UB(12) = 30;                                   % n2
LB(13) = 0; UB(13) = 30;                                   % n3
LB(14) = 0; UB(14) = 30;                                   % n4

% simulated annealing 

[bp bsc] = SimAnnFit4d(logic1,logic2,p_t1,p_t2,p_t3,p_t4,trg_syn,LB,UB);

for i=1:4
    if (lam(i)~=0)
        bp(i) = lam(i);
    end
end

model.n_tfs = 4;
model.tf_id = tf;
model.n_trgs = 1;
model.rep = rep;
model.logic = [logic1 logic2];
model.trg_id = trg;

model.p0(1) = set_p0(tf_expr1,bp(1));
model.lambdaP(1) = bp(1);

model.p0(2) = set_p0(tf_expr2,bp(2));
model.lambdaP(2) = bp(2);

model.p0(3) = set_p0(tf_expr3,bp(3));
model.lambdaP(3) = bp(3);

model.p0(4) = set_p0(tf_expr4,bp(4));
model.lambdaP(4) = bp(4);

model.b = bp(5);
model.K = bp(7:10);
model.n = bp(11:14);
model.alpha_max = bp(6);
model.best_score = bsc;
model.norm_score = bsc/(42*var(trg_syn));

