function model = LearnGRF_no_lambda (tf,lp,trg,logic,rep)

global expr1;
global expr2;
global syn1;
global syn2;

if (nargin~=5)
    error('expecting 5 arguments.')
end

start_par = [];
print = false;

lambda = 0.0005;
tau = 100;
theta0 = 0.1;

if (numel(tf)==1)
    
    % time
    t = 0:5:205;

    %data
    if (rep==1)
        tf_expr = expr1(tf,:);
        trg_syn = syn1(trg,:);
    elseif(rep==2)
        tf_expr = expr2(tf,:);
        trg_syn = syn2(trg,:);
    elseif (rep==0)
        tf_expr = 0.5*(expr1(tf,:)+expr2(tf,:));
        trg_syn = 0.5*(syn1(trg,:)+syn2(trg,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end

    nans = isnan(tf_expr);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr(i);
              j=j+1;
          end
       end
       tf_expr = interp1(tt,xx,t,'spline');
    end
    
    % define boundaries
    LB = zeros(1,4);
    UB = LB;
    LB(1) = 0; UB(1) = 1000*max(trg_syn);                      % b
    %LB(2) = 0.01*max(trg_syn); UB(2) = 1000*max(trg_syn);      % a_max
    LB(2) = 0.01*max(trg_syn); UB(2) = 2*(max(trg_syn)-min(trg_syn));      % a_max
    LB(3) = 0; UB(3) = 100*max(tf_expr);                       % K
    LB(4) = 0; UB(4) = 30;                                     % n
    
    % pre-calculate p(t)
    p0 = set_p0(tf_expr,lp(1));
    p_t1 = protein_traj(tf_expr,t,p0,lp(1),lp(1));
        
    % simulated annealing
    if (logic ~= 0)
        if (print)
            if (isempty(start_par))
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end

            figure; plot(resh);
            figure; plot(th);
            figure; plot(arh);
        else
            if (isempty(start_par))
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end
        end

        model.n_tfs = 1;
        model.tf_id = tf;
        model.n_trgs = 1;
        model.rep = rep;
        model.logic = logic;
        model.trg_id = trg;

        model.p0 = set_p0(tf_expr,lp(1));
        model.lambdaP = lp;

        model.b = bp(1);
        model.K = bp(3);
        model.n = bp(4);
        model.alpha_max = bp(2);
        model.best_score = bsc;
        model.norm_score = bsc/(42*var(trg_syn));
    
    else
        
       for l = 1:2
           if (print)
                if (isempty(start_par))
                    [bp bsc resh th arh] = SimAnnFit_lambda(l,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc resh th arh] = SimAnnFit_lambda(l,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end

                figure; plot(resh);
                figure; plot(th);
                figure; plot(arh);
            else
                if (isempty(start_par))
                    [bp bsc] = SimAnnFit_lambda(l,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc] = SimAnnFit_lambda(l,p_t1,[],[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end
            end
            mm(l).n_tfs = 1;
            mm(l).tf_id = tf;
            mm(l).n_trgs = 1;
            mm(l).rep = rep;
            mm(l).logic = l;
            mm(l).trg_id = trg;

            mm(l).p0 = set_p0(tf_expr,lp(1));
            mm(l).lambdaP = lp(1);

            mm(l).b = bp(1);
            mm(l).K = bp(2);
            mm(l).n = bp(4);
            mm(l).alpha_max = bp(4);
            mm(l).best_score = bsc;
            mm(l).norm_score = bsc/(42*var(trg_syn));
       end 
       
       if (mm(1).best_score < mm(2).best_score)
           model = mm(1);
       else
           model = mm(2);
       end
        
    end
    
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif (numel(tf) == 2)
    
    % time
    t = 0:5:205;

    %data
    if (rep==1)
        tf_expr1 = expr1(tf(1),:);
        tf_expr2 = expr1(tf(2),:);
        trg_syn = syn1(trg,:);
    elseif(rep==2)
        tf_expr1 = expr2(tf(1),:);
        tf_expr2 = expr2(tf(2),:);
        trg_syn = syn2(trg,:);
    elseif (rep==0)
        tf_expr1 = 0.5*(expr1(tf(1),:)+expr2(tf(1),:));
        tf_expr2 = 0.5*(expr1(tf(2),:)+expr2(tf(2),:));
        trg_syn = 0.5*(syn1(trg,:)+syn2(trg,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end

    nans = isnan(tf_expr1);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr1(i);
              j=j+1;
          end
       end
       tf_expr1 = interp1(tt,xx,t,'spline');
    end
    
    nans = isnan(tf_expr2);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr2(i);
              j=j+1;
          end
       end
       tf_expr2 = interp1(tt,xx,t,'spline');
    end
    
    % define boundaries
    LB = zeros(1,6);
    UB = LB;
    LB(1) = 0; UB(1) = 1000*(max(trg_syn)-min(trg_syn));                      % b
    %LB(2) = 0.01*max(trg_syn); UB(2) = 1000*max(trg_syn);      % a_max
    LB(2) = 0.01*max(trg_syn); UB(2) = 2*(max(trg_syn)-min(trg_syn));      % a_max
    LB(3) = 0; UB(3) = 100*max(tf_expr1);                      % K1
    LB(4) = 0; UB(4) = 100*max(tf_expr2);                      % K2
    LB(5) = 0; UB(5) = 30;                                     % n1
    LB(6) = 0; UB(6) = 30;                                     % n2
    
    % pre-calculate p(t)
    p0 = set_p0(tf_expr1,lp(1));
    p_t1 = protein_traj(tf_expr1,t,p0,lp(1),lp(1));
    p0 = set_p0(tf_expr2,lp(2));
    p_t2 = protein_traj(tf_expr2,t,p0,lp(2),lp(2));
    
    % simulated annealing
    if (logic ~= 0)
        if (print)
            if (isempty(start_par))
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end

            figure; plot(resh);
            figure; plot(th);
            figure; plot(arh);
        else
            if (isempty(start_par))
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end
        end

        model.n_tfs = 2;
        model.tf_id = tf;
        model.n_trgs = 1;
        model.rep = rep;
        model.logic = logic;
        model.trg_id = trg;

        model.p0(1) = set_p0(tf_expr1,lp(1));
        model.lambdaP(1) = lp(1);

        model.p0(2) = set_p0(tf_expr2,lp(2));
        model.lambdaP(2) = lp(2);

        model.b = bp(1);
        model.K = [bp(3) bp(4)];
        model.n = [bp(5) bp(6)];
        model.alpha_max = bp(2);
        model.best_score = bsc;
        model.norm_score = bsc/(42*var(trg_syn));
        
    else
        
        % determine direction of regulation individually
        mi1 = SimAnn_lambda(tf(1),lp(1),trg,0,rep);
        mi2 = SimAnn_lambda(tf(2),lp(2),trg,0,rep);
        if (mi1.logic == 1 && mi2.logic == 1)
           ll = [1 4 5]; ln = 3;
        elseif (mi1.logic == 1 && mi2.logic == 2)
           ll = [2 7]; ln = 2;
        elseif (mi1.logic == 2 && mi2.logic == 1)
           ll = [3 8]; ln = 2;
        elseif (mi1.logic == 2 && mi2.logic == 2)
           ll = [6 9 10]; ln = 3;
        end
        
        best = 1e300;
        for l=1:ln
            
            if (print)
                if (isempty(start_par))
                    [bp bsc resh th arh] = SimAnnFit_lambda(ll(l),p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc resh th arh] = SimAnnFit_lambda(ll(l),p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end

                figure; plot(resh);
                figure; plot(th);
                figure; plot(arh);
            else
                if (isempty(start_par))
                    [bp bsc] = SimAnnFit_lambda(ll(l),p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc] = SimAnnFit_lambda(ll(l),p_t1,p_t2,[],trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end
            end
            
            mm(l).n_tfs = 2;
            mm(l).tf_id = tf;
            mm(l).n_trgs = 1;
            mm(l).rep = rep;
            mm(l).logic = ll(l);
            mm(l).trg_id = trg;

            mm(l).p0(1) = set_p0(tf_expr1,lp(1));
            mm(l).lambdaP(1) = lp(1);

            mm(l).p0(2) = set_p0(tf_expr2,lp(2));
            mm(l).lambdaP(2) = lp(2);

            mm(l).b = bp(1);
            mm(l).K = [bp(3) bp(4)];
            mm(l).n = [bp(5) bp(6)];
            mm(l).alpha_max = bp(2);
            mm(l).best_score = bsc;
            mm(l).norm_score = bsc/(42*var(trg_syn));
            
            if (mm(l).best_score < best)
                best_l = l;
                best = mm(l).best_score;
            end
            
        end
        
        model = mm(best_l);
        
    end
     
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif (numel(tf) == 3)
    
    % time
    t = 0:5:205;

    %data
    if (rep==1)
        tf_expr1 = expr1(tf(1),:);
        tf_expr2 = expr1(tf(2),:);
        tf_expr3 = expr1(tf(3),:);
        trg_syn = syn1(trg,:);
    elseif(rep==2)
        tf_expr1 = expr2(tf(1),:);
        tf_expr2 = expr2(tf(2),:);
        tf_expr3 = expr2(tf(3),:);
        trg_syn = syn2(trg,:);
    elseif (rep==0)
        tf_expr1 = 0.5*(expr1(tf(1),:)+expr2(tf(1),:));
        tf_expr2 = 0.5*(expr1(tf(2),:)+expr2(tf(2),:));
        tf_expr3 = 0.5*(expr1(tf(3),:)+expr2(tf(3),:));
        trg_syn = 0.5*(syn1(trg,:)+syn2(trg,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end

    nans = isnan(tf_expr1);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr1(i);
              j=j+1;
          end
       end
       tf_expr1 = interp1(tt,xx,t,'spline');
    end
    
    nans = isnan(tf_expr2);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr2(i);
              j=j+1;
          end
       end
       tf_expr2 = interp1(tt,xx,t,'spline');
    end
    
    nans = isnan(tf_expr3);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr3(i);
              j=j+1;
          end
       end
       tf_expr3 = interp1(tt,xx,t,'spline');
    end
    
    % define boundaries
    LB = zeros(1,8);
    UB = LB;
    LB(1) = 0; UB(1) = 1000*max(trg_syn);                      % b
    %LB(2) = 0.01*max(trg_syn); UB(2) = 1000*max(trg_syn);      % a_max
    LB(2) = 0.01*max(trg_syn); UB(2) = 2*(max(trg_syn)-min(trg_syn));      % a_max
    LB(3) = 0; UB(3) = 100*max(tf_expr1);                      % K1
    LB(4) = 0; UB(4) = 100*max(tf_expr2);                      % K2
    LB(5) = 0; UB(5) = 100*max(tf_expr2);                      % K3
    LB(6) = 0; UB(6) = 30;                                     % n1
    LB(7) = 0; UB(7) = 30;                                     % n2
    LB(8) = 0; UB(8) = 30;                                     % n3
    
    % pre-calculate p(t)
    p0 = set_p0(tf_expr1,lp(1));
    p_t1 = protein_traj(tf_expr1,t,p0,lp(1),lp(1));
    p0 = set_p0(tf_expr2,lp(2));
    p_t2 = protein_traj(tf_expr2,t,p0,lp(2),lp(2));
    p0 = set_p0(tf_expr3,lp(3));
    p_t3 = protein_traj(tf_expr3,t,p0,lp(3),lp(3));
    
    
    % simulated annealing
    if (logic ~= 0)
        if (print)
            if (isempty(start_par))
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc resh th arh] = SimAnnFit_lambda(logic,p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end

            figure; plot(resh);
            figure; plot(th);
            figure; plot(arh);
        else
            if (isempty(start_par))
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0);
            else
                [bp bsc] = SimAnnFit_lambda(logic,p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0,start_par);
            end
        end
        
        model.n_tfs = 3;
        model.tf_id = tf;
        model.n_trgs = 1;
        model.rep = rep;
        model.logic = logic;
        model.trg_id = trg;

        model.p0(1) = set_p0(tf_expr1,lp(1));
        model.lambdaP(1) = lp(1);

        model.p0(2) = set_p0(tf_expr2,lp(2));
        model.lambdaP(2) = lp(2);

        model.p0(3) = set_p0(tf_expr3,lp(3));
        model.lambdaP(3) = lp(3);

        model.b = bp(1);
        model.K = bp(3:5);
        model.n = bp(6:8);
        model.alpha_max = bp(2);
        model.best_score = bsc;
        model.norm_score = bsc/(42*var(trg_syn));
        
    else
        
        % determine direction of regulation individually
        mi1 = SimAnn_lambda(tf(1),lp(1),trg,0,rep);
        mi2 = SimAnn_lambda(tf(2),lp(2),trg,0,rep);
        if (mi1.logic == 1 && mi2.logic == 1)
           ll = [1 4 5]; ln = 3;
        elseif (mi1.logic == 1 && mi2.logic == 2)
           ll = [2 7]; ln = 2;
        elseif (mi1.logic == 2 && mi2.logic == 1)
           ll = [3 8]; ln = 2;
        elseif (mi1.logic == 2 && mi2.logic == 2)
           ll = [6 9 10]; ln = 3;
        end
        
        best = 1e300;
        for l=1:ln
            
            if (print)
                if (isempty(start_par))
                    [bp bsc resh th arh] = SimAnnFit_lambda(ll(l),p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc resh th arh] = SimAnnFit_lambda(ll(l),p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end

                figure; plot(resh);
                figure; plot(th);
                figure; plot(arh);
            else
                if (isempty(start_par))
                    [bp bsc] = SimAnnFit_lambda(ll(l),p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0);
                else
                    [bp bsc] = SimAnnFit_lambda(ll(l),p_t1,p_t2,p_t3,trg_syn,LB,UB,lambda,tau,theta0,start_par);
                end
            end
            
            mm(l).n_tfs = 3;
            mm(l).tf_id = tf;
            mm(l).n_trgs = 1;
            mm(l).rep = rep;
            mm(l).logic = ll(l);
            mm(l).trg_id = trg;

            mm(l).p0(1) = set_p0(tf_expr1,lp(1));
            mm(l).lambdaP(1) = lp(1);

            mm(l).p0(2) = set_p0(tf_expr2,lp(2));
            mm(l).lambdaP(2) = lp(2);

            mm(l).p0(3) = set_p0(tf_expr3,lp(3));
            mm(l).lambdaP(3) = lp(3);

            mm(l).b = bp(1);
            mm(l).K = bp(3:5);
            mm(l).n = bp(6:8);
            mm(l).alpha_max = bp(2);
            mm(l).best_score = bsc;
            mm(l).norm_score = bsc/(42*var(trg_syn));
            
            if (mm(l).best_score < best)
                best_l = l;
                best = mm(l).best_score;
            end
            
        end
        
        model = mm(best_l);
        
    end

end