function [ns,n,l] = Learn_lambda (tf,trgs,rep,N)

grid = 500;
li = linspace(log(2)/70,log(2)/5,grid);
ns = zeros(length(trgs),grid);
ni = ones(1,grid);

pt = protein_grid(tf,rep,10000);

for i=1:length(trgs)
    
    fprintf('\nMCMC for target gene %i of %i',i,length(trgs));
    
    [s,m] = MCMC_flam(tf,pt,trgs(i),rep,N);
    
    fprintf('used logic: %i\n',m.logic);
    
    ns(i,:) = hist(s(:,1),li);
    ns(i,:) = ns(i,:)/sum(ns(i,:));
    
    ni = ni .* ns(i,:);
    ni = ni/sum(ni);
 
end

if (nargout >= 2)
    n = ni;
    if (nargout >= 3)
        l = li;
    end
end
    