function [ns1,ns2,n1,n2,l] = Learn_lambda_2d (tf,trgs,rep,N)

Ngrid = 10000;
grid = 500;
li = linspace(log(2)/70,log(2)/5,grid);
ns1 = zeros(length(trgs),grid);
ni1 = ones(1,grid);
ns2 = zeros(length(trgs),grid);
ni2 = ones(1,grid);

pt = zeros(2,Ngrid,42);
pt(1,:,:) = protein_grid(tf(1),rep,Ngrid);
pt(2,:,:) = protein_grid(tf(2),rep,Ngrid);

for i=1:length(trgs)
    
    fprintf('\nMCMC for target gene %i of %i',i,length(trgs));
    
    [s,m] = MCMC_flam(tf,pt,trgs(i),rep,N);
    
    fprintf('used logic: %i\n',m.logic);
    
    ns1(i,:) = hist(s(:,1),li);
    ns1(i,:) = ns1(i,:)/sum(ns1(i,:));
    ns2(i,:) = hist(s(:,2),li);
    ns2(i,:) = ns2(i,:)/sum(ns2(i,:));
    
    ni1 = ni1 .* ns1(i,:);
    ni1 = ni1/sum(ni1);
    ni2 = ni2 .* ns2(i,:);
    ni2 = ni2/sum(ni2);
    
end

if (nargout >= 3)
    n1 = ni1;
    n2 = ni2;
    if (nargout >= 5)
        l = li;
    end
end