function [s,m] = MCMC_flam (tf,pt,trg,rep,N,model)

% @args:
% tfn - number(s) of tf's in tfs1

global expr1;
global expr2;
global syn1;
global syn2;
global p_t;
global p_t2;
global trg_syn;
global LB;
global UB;
global Ngrid;

Ngrid = 10000;
    
% time
t = 0:5:205;

if (length(tf)==1)

    % protein traj
    p_t = pt;

    %data
    if (rep==1)
        tf_expr = expr1(tf,:);
        trg_syn = syn1(trg,:);
    elseif(rep==2)
        tf_expr = expr2(tf,:);
        trg_syn = syn2(trg,:);
    elseif (rep==0)
        tf_expr = 0.5*(expr1(tf,:)+expr2(tf,:));
        trg_syn = 0.5*(syn1(trg,:)+syn2(trg,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end

    nans = isnan(tf_expr);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr(i);
              j=j+1;
          end
       end
       tf_expr = interp1(tt,xx,t,'spline');
    end

    % define boundaries
    LB = zeros(1,5);
    UB = LB;
    LB(1) = log(2)/70; UB(1) = log(2)/5;                       % lp
    LB(2) = 0; UB(2) = 1000*max(trg_syn);                      % b
    LB(3) = 0.01*max(trg_syn); UB(3) = 1000*max(trg_syn);      % a_max
    LB(4) = 0; UB(4) = 100*max(tf_expr);                       % K
    LB(5) = 0; UB(5) = 30;                                     % n

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% Find logic and data variance sigma_d

    fprintf('\nestimating logic and data variance...0/4');
    
    if (nargin == 5)
       
        % find logic and best fit
        m = LearnGRF(tf,trg,0,rep,p_t);

        fprintf('\b\b\b1/4');

        logic = m.logic;

        for i = 1:3
            m1 = LearnGRF(tf,trg,logic,rep,p_t);
            fprintf('\b\b\b%i/6',i);
            if (m1.norm_score < m.norm_score)
                m = m1;
            end
        end

        % determine data variance
        sigma_d = 42*var(trg_syn)/100;

        fprintf('\b\b\bdone!\n');
    else
        logic = model.logic;
        m = model;
        sigma_d = 42*var(trg_syn)/100;
        fprintf('using model provided by user.\n');
    end
        


    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% fix proposal function variance by acceptance ratio

    fprintf('searching optimal proposal function variance....0');

    sigma_p = (UB-LB)/100; % initial guess
    M = 100; % number of feedback repeats

    % random numbers
    rnd_acc = rand(5000*M,1);
    rnd_p = randn(1000*M,5);

    lin = 1;

    z = [m.lambdaP,m.b,m.alpha_max,m.K,m.n];
    l = mcmc_ll(z,logic,sigma_d);

    acc_hist = zeros(M,1);

    for i = 1:M

        % MCMC run with current sigma_p
        n_acc = zeros(1,5);
        for j = 1:1000
            for k = 1:5

                zp = z;
                zp(k) = zp(k) + rnd_p(j,k)*sigma_p(k);
                lp = mcmc_ll(zp,logic,sigma_d);
                p = min(1,exp((l-lp)/2));

                if (rnd_acc(lin) <= p)
                    l = lp;
                    z = zp;
                    n_acc(k) = n_acc(k) + 1;
                end
                lin = lin+1;
            end
        end

        % feedback of acceptance ratio
        n_acc = n_acc/1000;
        acc_hist(i) = mean(n_acc);

        for k = 1:5
           sigma_p(k) = sigma_p(k)*max(0.1,(n_acc(k)/0.27)); 
        end

        if (i < 10)
            fprintf('\b%i',i);
        else
            fprintf('\b\b%i',i);
        end

    end

    fprintf('\b\b\bdone!\n');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% skip burn-in period

    fprintf('performing de-correlation run...');

    M = 100000; % length of burn-in
    j = 0;

    % random numbers
    rnd_acc = rand(5*M,1);
    rnd_p = randn(M,5);

    l = mcmc_ll(z,logic,sigma_d);

    for i = 1:M

        for k=1:5
        
            zp = z;
            zp(k) = z(k) + rnd_p(i,k).*sigma_p(k);
            lp = mcmc_ll(zp,logic,sigma_d);
            p = min(1,exp((l-lp)/2));
            j=j+1;

            if (rnd_acc(j) <= p)
                l = lp;
                z = zp;
            end
            
        end

    end

    fprintf('done!\n');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% sample from posterior distribution

    fprintf('sampling from posterior distribution....0');

    s = zeros(N,5);

    % random numbers
    rnd_acc = rand(5*N,1);
    rnd_p = randn(N,5);
    r = 0;

    M = N/100;
    j = 0;
    x = 1;

    for i = 1:N

        for k=1:5
        
            zp = z;
            zp(k) = z(k) + rnd_p(i,k).*sigma_p(k);
            lp = mcmc_ll(zp,logic,sigma_d);
            p = min(1,exp((l-lp)/2));
            r=r+1;

            if (rnd_acc(r) <= p)
                l = lp;
                z = zp;
            end
            
        end

        s(i,:) = z;
        j=j+1;

        if (j == M)
           if (x<10)
               fprintf('\b%i',x);
           else
               fprintf('\b\b%i',x);
           end
           x=x+1;
           j=0;
        end

    end

    fprintf('\b\b\bdone!\n');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2 DIM CASE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif (length(tf) == 2)
    
    % protein traj
    p_t = squeeze(pt(1,:,:));
    p_t2 = squeeze(pt(2,:,:));

    %data
    if (rep==1)
        tf_expr1 = expr1(tf(1),:);
        tf_expr2 = expr1(tf(2),:);
        trg_syn = syn1(trg,:);
    elseif(rep==2)
        tf_expr1 = expr2(tf(1),:);
        tf_expr2 = expr2(tf(2),:);
        trg_syn = syn2(trg,:);
    elseif (rep==0)
        tf_expr1 = 0.5*(expr1(tf(1),:)+expr2(tf(1),:));
        tf_expr2 = 0.5*(expr1(tf(2),:)+expr2(tf(1),:));
        trg_syn = 0.5*(syn1(trg,:)+syn2(trg,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end

    nans = isnan(tf_expr1);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr1(i);
              j=j+1;
          end
       end
       tf_expr1 = interp1(tt,xx,t,'spline');
    end
    
    nans = isnan(tf_expr2);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = tf_expr2(i);
              j=j+1;
          end
       end
       tf_expr2 = interp1(tt,xx,t,'spline');
    end

    % define boundaries
    LB = zeros(1,8);
    UB = LB;
    LB(1) = log(2)/70; UB(1) = log(2)/5;                       % lp 1
    LB(2) = log(2)/70; UB(2) = log(2)/5;                       % lp 2
    LB(3) = 0; UB(3) = 1000*max(trg_syn);                      % b
    LB(4) = 0.01*max(trg_syn); UB(4) = 1000*max(trg_syn);      % a_max
    LB(5) = 0; UB(5) = 100*max(tf_expr1);                      % K 1
    LB(6) = 0; UB(6) = 100*max(tf_expr2);                      % K 2
    LB(7) = 0; UB(7) = 30;                                     % n 1
    LB(8) = 0; UB(8) = 30;                                     % n 2

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% Find logic and data variance sigma_d

    fprintf('\nestimating logic and data variance...0/4');

    if (nargin == 5)
    
        % find logic and best fit
        m = LearnGRF(tf,trg,0,rep,p_t,p_t2);
        
        fprintf('\b\b\b1/4');

        logic = m.logic;

        for i = 1:3
            m1 = LearnGRF(tf,trg,logic,rep,p_t,p_t2);
            fprintf('\b\b\b%i/4',i);
            if (m1.norm_score < m.norm_score)
                m = m1;
            end
        end

        % determine data variance
        sigma_d = 42*var(trg_syn)/100;
        %sigma_d = 42*var(trg_syn)/75;

        fprintf('\b\b\bdone!\n');
    else
        logic = model.logic;
        m = model;
        sigma_d = 42*var(trg_syn)/100;
        fprintf('\b\b\busing model provided by user.\n');
    end


    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% fix proposal function variance by acceptance ratio

    fprintf('searching optimal proposal function variance....0');

    sigma_p = (UB-LB)/100; % initial guess
    M = 100; % number of feedback repeats

    % random numbers
    rnd_acc = rand(8000*M,1);
    rnd_p = randn(1000*M,8);

    lin = 1;

    z = [m.lambdaP(1),m.lambdaP(2),m.b,m.alpha_max,m.K(1),m.K(2),m.n(1),m.n(2)];
    l = mcmc_ll_2d(z,logic,sigma_d);

    acc_hist = zeros(M,1);

    for i = 1:M

        % MCMC run with current sigma_p
        n_acc = zeros(1,8);
        for j = 1:1000
            for k = 1:8

                zp = z;
                zp(k) = zp(k) + rnd_p(j,k)*sigma_p(k);
                lp = mcmc_ll_2d(zp,logic,sigma_d);
                p = min(1,exp((l-lp)/2));

                if (rnd_acc(lin) <= p)
                    l = lp;
                    z = zp;
                    n_acc(k) = n_acc(k) + 1;
                end
                lin = lin+1;
            end
        end

        % feedback of acceptance ratio
        n_acc = n_acc/1000;
        acc_hist(i) = mean(n_acc);

        for k = 1:8
           sigma_p(k) = sigma_p(k)*max(0.1,(n_acc(k)/0.27)); 
        end

        if (i < 10)
            fprintf('\b%i',i);
        else
            fprintf('\b\b%i',i);
        end

    end

    fprintf('\b\b\bdone!\n');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% skip burn-in period

    fprintf('performing de-correlation run...');

    M = 100000; % length of burn-in
    j = 0;

    % random numbers
    rnd_acc = rand(M*8,1);
    rnd_p = randn(M,8);

    l = mcmc_ll_2d(z,logic,sigma_d);
    
    for i = 1:M

        for k = 1:8
        
            zp = z;
            zp(k) = z(k) + rnd_p(i,k).*sigma_p(k);
            lp = mcmc_ll_2d(zp,logic,sigma_d);
            p = min(1,exp((l-lp)/2));
            j=j+1;

            if (rnd_acc(j) <= p)
                l = lp;
                z = zp;
            end
        
        end

    end

    fprintf('done!\n');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%% sample from posterior distribution

    fprintf('sampling from posterior distribution....0');

    s = zeros(N,8);

    % random numbers
    rnd_acc = rand(N*8,1);
    rnd_p = randn(N,8);

    M = N/100;
    j = 0;
    x = 1;
    r = 0;

    for i = 1:N
        
        for k = 1:8
        
            zp = z;
            zp(k) = z(k) + rnd_p(i,k).*sigma_p(k);
            lp = mcmc_ll_2d(zp,logic,sigma_d);
            p = min(1,exp((l-lp)/2));
            r=r+1;

            if (rnd_acc(r) <= p)
                l = lp;
                z = zp;
            end
        
        end

        s(i,:) = z;
        j=j+1;

        if (j == M)
           if (x<10)
               fprintf('\b%i',x);
           else
               fprintf('\b\b%i',x);
           end
           x=x+1;
           j=0;
        end

    end

    fprintf('\b\b\bdone!\n');
    
end


