function netw_ode = fit_network(net, models,rep)

global expr1;
global expr2;
global m_cln;
global t_cln;
global t_fit;

t_fit = 205;

for i = 1:length(net.network)
   netw(i) = models(net.network(i));
end

expr = zeros(length(netw),42);
for i = 1:length(netw)
   if (rep == 1)
       expr(i,:) = expr1(netw(i).trg_id,:);
   else
       expr(i,:) = expr2(netw(i).trg_id,:);
   end
end

lp = zeros(1,length(net));

cln_lp = [];
for i = 1:length(netw)
   for j = 1:length(netw)
      for k = 1:length(netw(j).tf_id);
          if (netw(j).tf_id(k) == g('cln2'))
               netw(j).tf_id(k) = -1;
               cln_lp = netw(j).lambdaP(k);
          elseif (netw(j).tf_id(k) == netw(i).trg_id)
             lp(i) = netw(j).lambdaP(k); 
          end
      end
   end
end

for i = 1:length(netw)
   netw(i).lambdaP = lp(i); 
   netw(i).ap = lp(i); 
end

y0 = zeros(length(netw)*2,1);
tfs = zeros(1,length(netw));

for i=1:length(netw)
   netw(i).lm = FitLamm(netw(i).trg_id,rep);
   if (rep == 1)
      y0(2*i-1) = expr1(netw(i).trg_id,1);
      y0(2*i) = set_p0(expr1(netw(i).trg_id,:),netw(i).lambdaP);
   elseif (rep == 2)
      y0(2*i-1) = expr2(netw(i).trg_id,1);
      y0(2*i) = set_p0(expr2(netw(i).trg_id,:),netw(i).lambdaP);
   end
   tfs(i) = netw(i).trg_id;
end

for i=1:length(netw)  
   for k = 1:length(netw)
      if (tfs(k)==netw(i).trg_id)
          break;
      end
   end
   netw(i).trg_id = k;
   
   for j=1:length(netw(i).tf_id)       
       for k = 1:length(netw)
          if (tfs(k)==netw(i).tf_id(j))
              break;
          end
       end
       if (netw(i).tf_id(j) ~= -1)
           netw(i).tf_id(j) = k;
       end
   end
end

if (isempty(cln_lp))
    m_cln = [];
    netw_ode.use_cln = false;
else
    netw_ode.use_cln = true;
    if (rep == 1)
       t_cln = 0:5:t_fit;
       m_cln0 = expr1(g('cln2'),:); 
       m_cln = m_cln0(1:length(t_cln));
    elseif (rep == 2)
       t_cln = 0:5:t_fit;
       m_cln0 = expr2(g('cln2'),:); 
       m_cln = m_cln0(1:length(t_cln));
    end
end
    

global netz;
netz = netw;

%%%% fit parameter

k=1;
for i = 1:length(netz)
    
   par0(k) = netz(i).lambdaP; k=k+1;
   par0(k) = netz(i).lm; k=k+1;
   par0(k) = netz(i).b; k=k+1;
   par0(k) = netz(i).alpha_max; k=k+1;
   if (netz(i).n_tfs == 1)
      par0(k) = netz(i).K; k=k+1; 
      par0(k) = netz(i).n; k=k+1; 
   elseif (netz(i).n_tfs == 2)
      par0(k) = netz(i).K(1); k=k+1;
      par0(k) = netz(i).K(2); k=k+1;
      par0(k) = netz(i).n(1); k=k+1;
      par0(k) = netz(i).n(2); k=k+1;
   else
      par0(k) = netz(i).K(1); k=k+1;
      par0(k) = netz(i).K(2); k=k+1;
      par0(k) = netz(i).K(3); k=k+1;
      par0(k) = netz(i).n(1); k=k+1;
      par0(k) = netz(i).n(2); k=k+1;
      par0(k) = netz(i).n(3); k=k+1;
   end
    
end
% cln
if (netw_ode.use_cln)
    par0(end+1) = cln_lp;
end

opt = optimset('TolFun',1e-2,'TolX',1e10,'Display','iter','MaxFunEvals',5000000,'MaxIter',5000000);
par = fminsearch(@(par)sim_network_fit_costs(par,y0,expr),par0,opt);

netw_ode.netw = netz;
netw_ode.y0 = y0;
netw_ode.rep = rep;
netw_ode.tfs = tfs;
if (netw_ode.use_cln)
   netw_ode.m_cln = m_cln0;
   netw_ode.cln_lp = cln_lp;
end