function dydt = logicfun2vec(I,p1,p2,n1,n2,k1,k2)
%takes values of 2 TF proteins as vectors and outputs a vector of regulation function
%values for each possible '2 input logic function'.
%Logic functions are labelled by their name and their truth table where the columns are:
% [A B] = [0 0] [1 0] [0 1] [1 1]


switch I
    case 1 %A AND B 	0 0 0 1 

        dydt =  ((p1.^n1)./(p1.^n1 + k1^n1) ) .*...
                    ( (p2.^n2)./(p2.^n2 + k2^n2) ) ;

    case 2 % A AND (NOT B)	0 0 1 0

        dydt =  ( (p1.^n1)./(p1.^n1 + k1^n1) ) .*...
                    ( (k2^n2)./(p2.^n2 + k2^n2) );

    case 3 % B AND (NOT A)	0 1 0 0

        dydt =  ( (k1^n1)./(p1.^n1 + k1^n1) ) .*...
                    ( (p2.^n2)./(p2.^n2 + k2^n2) );

    case 4 %A XOR B 	0 1 1 0

        dydt =  ( (p1.^n1)./(p1.^n1 + k1^n1)  ) .*...
                    (  (k2^n2)./(p2.^n2 + k2^n2) ) ...
                + ( (k1^n1)./(p1.^n1 + k1^n1)  ) .*...
                    (  (p2.^n2)./(p2.^n2 + k2^n2) ) ;

    case 5 %A OR B 	0 1 1 1

        dydt =   (p1.^n1)./(p1.^n1 + k1^n1)  +...
                    (p2.^n2)./(p2.^n2 + k2^n2) ;

    case 6 %A NOR B 	1 0 0 0 

        dydt = ( (k1^n1)./(p1.^n1 + k1^n1) ) .*...
                    ( (k2^n2)./(p2.^n2 + k2^n2) );

    case 7 %A OR (NOT B) 	1 0 1 1

        dydt =  (p1.^n1)./(p1.^n1 + k1^n1)  +...
                    (k2^n2)./(p2.^n2 + k2^n2) ;

    case 8 %B OR (NOT A) 	1 1 0 1

        dydt =  (k1^n1)./(p1.^n1 + k1^n1)  +...
                    (p2.^n2)./(p2.^n2 + k2^n2) ;

    case 9 %NOT (A AND B) 	1 1 1 0

        dydt =  (k1^n1)./(p1.^n1 + k1^n1)  +...
                    (k2^n2)./(p2.^n2 + k2^n2) ;

    case 10 %A=B 	1 0 0 1

        dydt =  ( (p1.^n1)./(p1.^n1 + k1^n1)  ) .*...
                    (  (p2.^n2)./(p2.^n2 + k2^n2) ) ...
                + ((k1^n1)./(p1.^n1 + k1^n1)  ) .*...
                    (  (k2^n2)./(p2.^n2 + k2^n2) ) ;

    case 11 %A 0 1 0 1
       dydt =  (p1.^n1)./(p1.^n1 + k1^n1);
        
        
    case 12 %NOT A 1 0 1 0
        
         dydt =  (k1^n1)./(p1.^n1 + k1^n1);
        
    case 13 %B 0 0 1 1
    
       dydt =  (p2.^n2)./(p2.^n2 + k2^n2);
       
    case 14 %NOT B 1 1 0 0
     
        dydt =  (k2^n2)./(p2.^n2 + k2^n2);
        
    case 15 % constant 1 1 1 1
        
        dydt = ones(size(p1));


    otherwise
        error(' error in logicfun2vec "logic" entry')
end



end