function L = mcmc_ll_2d (pars,logic,sig)

global trg_syn;
global p_t;
global p_t2;
global Ngrid;
global LB;
global UB;

if (numel(pars(pars<LB))>0 || numel(pars(pars>UB))>0)
    L = 1e300;
else

    i = floor((pars(1)-LB(1))*Ngrid/(UB(1)-LB(1)))+1;
    pt1 = p_t(i,:);
    
    i = floor((pars(2)-LB(2))*Ngrid/(UB(2)-LB(2)))+1;
    pt2 = p_t2(i,:);

    sm = pars(3) + pars(4) * logicfun2vec(logic,pt1,pt2,pars(7),pars(8),pars(5),pars(6));

    L = sm-trg_syn;
    L = (L*L')/sig;

end