function dy = netw_ode (t,y)

global netz;
global cln_p;
global t_cln;

% order of y (and dy) [m_1; p_1; m_2; p_2; ....]
% equations:
%            m' = P(p_j) - lm*m
%            p' = lp * (m - p)
% with
%            P(p_j) = b + a * logic(p_j)

N = length(netz);
dy = zeros(2*N,1);

if (~isempty(cln_p))
   if (t <= t_cln(length(t_cln)))
       p_cln = interp1(t_cln,cln_p,t); 
   else
       p_cln = mean(cln_p(20:42)); 
   end
end

for i=1:N
    
    % calculate logic 
    if (length(netz(i).tf_id)==1)
       p1 = y(2*netz(i).tf_id(1));
       L = logicfun1vec(netz(i).logic,p1,netz(i).n(1),netz(i).K(1));
    elseif (length(netz(i).tf_id)==2)
       p1 = y(2*netz(i).tf_id(1));
       if (netz(i).tf_id(2) == -1)
           p2 = p_cln;
       else
           p2 = y(2*netz(i).tf_id(2));
       end
       L = logicfun2vec(netz(i).logic,p1,p2,netz(i).n(1),netz(i).n(2),netz(i).K(1),netz(i).K(2));
    elseif (length(netz(i).tf_id)==4)
        for pi = 1:4
           if (netz(i).tf_id(pi) == -1)
               p(pi,:) = p_cln;
           else
               p(pi,:) = y(2*netz(i).tf_id(pi));
           end
        end
       L = logicfun2vec(netz(i).logic(1),p(1,:),p(2,:),netz(i).n(1),netz(i).n(2),netz(i).K(1),netz(i).K(2)) + logicfun2vec(netz(i).logic(2),p(3,:),p(4,:),netz(i).n(3),netz(i).n(4),netz(i).K(3),netz(i).K(4));
    end
    
    % calculate rhs equations
    dy(2*i-1) = netz(i).b + netz(i).alpha_max*L - netz(i).lm * y(2*i-1);
    dy(2*i) = netz(i).ap * y(2*i-1) - netz(i).lambdaP * y(2*i);
    
end