function [] = plotGRF(model,show_par)

if (nargin == 1)
    show_par = true;
end

global expr1;
global expr2;
global syn1;
global syn2;
global gene_names_std;

if (model.n_tfs == 1)
    
    %data
    if (model.rep==1)
        tf_expr = expr1(model.tf_id,:);
        trg_syn = syn1(model.trg_id,:);
    elseif(model.rep==2)
        tf_expr = expr2(model.tf_id,:);
        trg_syn = syn2(model.trg_id,:);
    elseif (model.rep==0)
        tf_expr = 0.5*(expr1(model.tf_id,:)+expr2(model.tf_id,:));
        trg_syn = 0.5*(syn1(model.trg_id,:)+syn2(model.trg_id,:));
    else
        error('argument rep must be 0,1, or 2.');
    end

    t=0:5:205;

    % fill missing data
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end
    nans = isnan(tf_expr);
    if (sum(nans)~=0)
        if (sum(nans) >= length(nans)-3)
            error('at least three values of target synthesis rate must not be NaN!');
        end
        tt = zeros(1,numel(nans(nans==0)));
        xx = tt;
        j=1;
        for i = 1:length(nans)
            if (nans(i)==0)
                tt(j) = t(i);
                xx(j) = tfe(k,i);
                j=j+1;
            end
        end
        tf_expr = interp1(tt,xx,t,'spline');
    end
    
    p = protein_traj(tf_expr,t,model.p0,model.lambdaP,model.lambdaP);
    p_reg = linspace(0.9*min(p),1.1*max(p),1000);
    
    figure('OuterPosition',[100 600 1000 600]);
        
    % expression vs. time
    synm_t = model.b+model.alpha_max*logicfun1vec(model.logic,p,model.n,model.K);
    synm_reg = model.b+model.alpha_max*logicfun1vec(model.logic,p_reg,model.n,model.K);
            
    subplot(3,2,1);
	plot(t,tf_expr,'r');
    axis([0 205 0.9*min(tf_expr) 1.1*max(tf_expr)]);
    ylabel(strcat('[',gene_names_std(model.tf_id),' mRNA]'),'fontsize',12);
    if (show_par)
        title(strcat(gene_names_std(model.tf_id),' -> ',gene_names_std(model.trg_id),sprintf('\n\np0 = %0.3g',model.p0),sprintf(', lambdaP = %0.3g',model.lambdaP)),'fontsize',12);
    else
        title(strcat(gene_names_std(model.tf_id),' -> ',gene_names_std(model.trg_id)),'fontsize',12);
    end
    
    subplot(3,2,3);
	plot(t,p);
    axis([0 205 0.9*min(p) 1.1*max(p)]);
    ylabel('protein model','FontSize',12);
    
    subplot(3,2,5);
	plot(t,trg_syn,'*');
    hold on;
	plot(t,synm_t);
    axis([0 205 0.9*min(trg_syn) 1.1*max(trg_syn)]);
    ylabel('model vs data','FontSize',12);
    xlabel('t [min]','FontSize',12);

	subplot(3,2,[4 6]);
	plot(p,trg_syn,'*');
	hold on;
	plot(p_reg,synm_reg);
	axis([p_reg(1) p_reg(1000) 0 1.1*max([synm_reg trg_syn])]);
	xlabel(strcat('[',gene_names_std(model.tf_id),']'),'fontsize',12);
	ylabel(strcat(gene_names_std(model.trg_id),' synthesis rate'),'fontsize',12);

	if (model.logic==1)
        logic = 'ACTIVATOR';
	elseif (model.logic==2)
        logic = 'REPRESSOR';
    end
 
    if (show_par)
        title(strcat('logic = ',logic,sprintf('\n\nb=%0.3g,',model.b),sprintf(' a_{max}=%0.3g,',model.alpha_max),sprintf(' K=%0.3g,',model.K),sprintf(' n=%0.3g',model.n),sprintf('\n\nscore = %f',model.norm_score)),'fontsize',12);
    else
        title(strcat('logic = ',logic),'fontsize',12);
    end
    
% ********************************************************************************************************    

elseif (model.n_tfs == 2)
    
    t=0:5:205;
    if (model.rep==1)
        exd1 = expr1(model.tf_id(1),:);
        exd2 = expr1(model.tf_id(2),:);
        trg_syn = syn1(model.trg_id,:);
    elseif (model.rep == 2)
        exd1 = expr2(model.tf_id(1),:);
        exd2 = expr2(model.tf_id(2),:);
        trg_syn = syn2(model.trg_id,:);
    else
        exd1 = 0.5*(expr1(model.tf_id(1),:)+expr2(model.tf_id(1),:));
        exd2 = 0.5*(expr1(model.tf_id(2),:)+expr2(model.tf_id(2),:));
        trg_syn = 0.5*(syn1(model.trg_id,:)+syn2(model.trg_id,:));
    end
    
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end
    
    figure('OuterPosition',[100 800 1200 750]);
            
    p1 = protein_traj(exd1,t,model.p0(1),model.lambdaP(1),model.lambdaP(1));
    p2 = protein_traj(exd2,t,model.p0(2),model.lambdaP(2),model.lambdaP(2));
    pm1 = linspace(0.9*min(p1),1.1*max(p1),30);
    pm2 = linspace(0.9*min(p2),1.1*max(p2),30);
    [PM1 PM2] = meshgrid(pm1,pm2);

    
    % expression vs. time
    synm_t = model.b+model.alpha_max*logicfun2vec(model.logic,p1,p2,model.n(1),model.n(2),model.K(1),model.K(2));
    synm_reg = model.b+model.alpha_max*logicfun2vec(model.logic,PM1,PM2,model.n(1),model.n(2),model.K(1),model.K(2));

    subplot(3,2,1);
    [AX,H1,H2] = plotyy(t,exd1,t,exd2);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(exd1) 1.1*max(exd1)]);
    axis(AX(2),[0 205 0.9*min(exd2) 1.1*max(exd2)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(1)),' mRNA]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(2)),' mRNA]'),'fontsize',12);
    if (show_par)
        title(strcat('(',gene_names_std(model.tf_id(1)),',',gene_names_std(model.tf_id(2)),') -> ',gene_names_std(model.trg_id),sprintf('\n\np0_1 = %0.3g, p0_2 = %0.3g',model.p0(1),model.p0(2)),sprintf('\nlambdaP_1 = %0.3g, lambdaP_2 = %0.3g',model.lambdaP(1),model.lambdaP(2))),'fontsize',12);
    else
        title(strcat('(',gene_names_std(model.tf_id(1)),',',gene_names_std(model.tf_id(2)),') -> ',gene_names_std(model.trg_id)),'fontsize',14);
    end
        
    subplot(3,2,3);
    [AX,H1,H2] = plotyy(t,p1,t,p2);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(p1) 1.1*max(p1)]);
    axis(AX(2),[0 205 0.9*min(p2) 1.1*max(p2)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(1)),'p]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(2)),'p]'),'fontsize',12);
    
    subplot(3,2,5);
    plot(t,synm_t);
    hold on;
    plot(t,trg_syn,'*');
    axis([0 205 0.9*min([trg_syn synm_t]) 1.1*max([trg_syn synm_t])]);
    ylabel(strcat(gene_names_std(model.trg_id),' acitivity'),'fontsize',12);
    xlabel('t [min]','fontsize',12);
    
    subplot(3,2,[4 6]);
    h=surf(pm1,pm2,synm_reg);
    box on;
    set(h,'FaceColor','none','LineWidth',2,'EdgeColor','interp');
    hold on;
    tmp=1.1*max(max(max(synm_reg)),max(trg_syn));
    axis([pm1(1) pm1(30) pm2(1) pm2(30) 0 tmp]);
    xlabel(strcat('[',gene_names_std(model.tf_id(1)),']'),'fontsize',12);
    ylabel(strcat('[',gene_names_std(model.tf_id(2)),']'),'fontsize',12);
    zlabel(strcat(gene_names_std(model.trg_id),' activity'),'fontsize',12);
    
    [xs ys zs] = sphere(20);
    xs=xs.*(0.025*(pm1(30)-pm1(1)));
    ys=ys.*(0.025*(pm2(30)-pm2(1)));
    zs=zs.*(0.025*tmp);
    
    for i=1:length(p1)
       xt=xs+p1(i);
       yt=ys+p2(i);
       zt=zs+trg_syn(i);
       surf(xt,yt,zt,'EdgeColor','none');
    end

	if (model.logic==1)
        logic = sprintf('%s AND %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==2)
        logic = sprintf('%s AND NOT %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==3)
        logic = sprintf('NOT %s AND %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==4)
        logic = sprintf('%s XOR %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==5)
        logic = sprintf('%s OR %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==6)
        logic = sprintf('%s NOR %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==7)
        logic = sprintf('%s OR NOT %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==8)
        logic = sprintf('%NOT s OR %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==9)
        logic = sprintf('%s NAND %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==10)
        logic = sprintf('%s EQ %s',gene_names_std{model.tf_id(1)},gene_names_std{model.tf_id(2)});
    elseif (model.logic==11)
        logic = sprintf('%s ACTIVATES',gene_names_std{model.tf_id(1)});
    elseif (model.logic==12)
        logic = sprintf('%s REPRESSES',gene_names_std{model.tf_id(1)});
    elseif (model.logic==13)
        logic = sprintf('%s ACTIVATES',gene_names_std{model.tf_id(2)});
    elseif (model.logic==14)
        logic = sprintf('%s REPRESSES',gene_names_std{model.tf_id(2)});
    elseif (model.logic==15)
        logic = 'NO REGULATION';
    end
    
    if (show_par)
        title(strcat('logic = ',logic,sprintf('\n\nb=%0.3g,',model.b),sprintf(' a_{max}=%0.3g,',model.alpha_max),sprintf(' K_1=%0.3g,',model.K(1)),sprintf('\nn_1=%0.3g',model.n(1)),sprintf(' K_2=%0.3g,',model.K(2)),sprintf(' n_2=%0.3g',model.n(2)),sprintf('\n\nscore = %f',model.norm_score)),'fontsize',12);
    else
        title(strcat('logic = ',logic),'fontsize',14);
    end

% ********************************************************************************************************    

elseif (model.n_tfs == 4)
    
    t=0:5:205;
    if (model.rep==1)
        exd1 = expr1(model.tf_id(1),:);
        exd2 = expr1(model.tf_id(2),:);
        exd3 = expr1(model.tf_id(3),:);
        exd4 = expr1(model.tf_id(4),:);
        trg_syn = syn1(model.trg_id,:);
    elseif (model.rep == 2)
        exd1 = expr2(model.tf_id(1),:);
        exd2 = expr2(model.tf_id(2),:);
        exd3 = expr2(model.tf_id(3),:);
        exd4 = expr2(model.tf_id(4),:);
        trg_syn = syn2(model.trg_id,:);
    end
    
    nans = isnan(trg_syn);
    if (sum(nans)~=0)
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for i = 1:length(nans)
          if (nans(i)==0)
              tt(j) = t(i);
              xx(j) = trg_syn(i);
              j=j+1;
          end
       end
       trg_syn = interp1(tt,xx,t,'spline');
    end
    
    figure('OuterPosition',[100 1000 1200 750]);
            
    p1 = protein_traj(exd1,t,model.p0(1),model.lambdaP(1),model.lambdaP(1));
    p2 = protein_traj(exd2,t,model.p0(2),model.lambdaP(2),model.lambdaP(2));
    p3 = protein_traj(exd3,t,model.p0(3),model.lambdaP(3),model.lambdaP(3));
    p4 = protein_traj(exd4,t,model.p0(4),model.lambdaP(4),model.lambdaP(4));
    
    pm1 = linspace(0.9*min(p1),1.1*max(p1),30);
    pm2 = linspace(0.9*min(p2),1.1*max(p2),30);
    pm3 = linspace(0.9*min(p3),1.1*max(p3),30);
    pm4 = linspace(0.9*min(p4),1.1*max(p4),30);
    
    [PM1 PM2] = meshgrid(pm1,pm2);
    [PM3 PM4] = meshgrid(pm3,pm4);
                
    % expression vs. time
    synm_t = model.b+model.alpha_max*( logicfun2vec(model.logic(1),p1,p2,model.n(1),model.n(2),model.K(1),model.K(2)) + logicfun2vec(model.logic(2),p3,p4,model.n(3),model.n(4),model.K(3),model.K(4)));
    synm_reg1 = model.b+model.alpha_max*logicfun2vec(model.logic(1),PM1,PM2,model.n(1),model.n(2),model.K(1),model.K(2));
    synm_reg2 = model.b+model.alpha_max*logicfun2vec(model.logic(2),PM3,PM4,model.n(3),model.n(4),model.K(3),model.K(4));
    
    subplot(3,2,1);
    [AX,H1,H2] = plotyy(t,exd1,t,exd2);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(exd1) 1.1*max(exd1)]);
    axis(AX(2),[0 205 0.9*min(exd2) 1.1*max(exd2)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(1)),' mRNA]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(2)),' mRNA]'),'fontsize',12);
    if (show_par)
        title(strcat('(',gene_names_std(model.tf_id(1)),',',gene_names_std(model.tf_id(2)),') -> ',gene_names_std(model.trg_id),sprintf('\n\np0_1 = %0.3g, p0_2 = %0.3g',model.p0(1),model.p0(2)),sprintf('\nlambdaP_1 = %0.3g, lambdaP_2 = %0.3g',model.lambdaP(1),model.lambdaP(2))),'fontsize',12);
    else
        title(strcat('(',gene_names_std(model.tf_id(1)),',',gene_names_std(model.tf_id(2)),') -> ',gene_names_std(model.trg_id)),'fontsize',14);
    end
        
    subplot(3,2,3);
    [AX,H1,H2] = plotyy(t,p1,t,p2);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(p1) 1.1*max(p1)]);
    axis(AX(2),[0 205 0.9*min(p2) 1.1*max(p2)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(1)),'p]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(2)),'p]'),'fontsize',12);
    
    subplot(3,2,5);
    plot(t,synm_t);
    hold on;
    plot(t,trg_syn,'*');
    axis([0 205 0.9*min([trg_syn synm_t]) 1.1*max([trg_syn synm_t])]);
    ylabel(strcat(gene_names_std(model.trg_id),' acitivity'),'fontsize',12);
    xlabel('t [min]','fontsize',12);
    
    subplot(3,2,[4 6]);
    h=surf(pm1,pm2,synm_reg1);
    box on;
    set(h,'FaceColor','none','LineWidth',2,'EdgeColor','interp');
    hold on;
    tmp=1.1*max(max(max(synm_reg1)),max(trg_syn));
    axis([pm1(1) pm1(30) pm2(1) pm2(30) 0 tmp]);
    xlabel(strcat('[',gene_names_std(model.tf_id(1)),']'),'fontsize',12);
    ylabel(strcat('[',gene_names_std(model.tf_id(2)),']'),'fontsize',12);
    zlabel(strcat(gene_names_std(model.trg_id),' activity'),'fontsize',12);

    figure('OuterPosition',[100 1000 1200 750]);
    
    subplot(3,2,1);
    [AX,H1,H2] = plotyy(t,exd3,t,exd4);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(exd3) 1.1*max(exd3)]);
    axis(AX(2),[0 205 0.9*min(exd4) 1.1*max(exd4)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(3)),' mRNA]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(4)),' mRNA]'),'fontsize',12);
    if (show_par)
        title(strcat('(',gene_names_std(model.tf_id(3)),',',gene_names_std(model.tf_id(4)),') -> ',gene_names_std(model.trg_id),sprintf('\n\np0_1 = %0.3g, p0_2 = %0.3g',model.p0(1),model.p0(2)),sprintf('\nlambdaP_1 = %0.3g, lambdaP_2 = %0.3g',model.lambdaP(1),model.lambdaP(2))),'fontsize',12);
    else
        title(strcat('(',gene_names_std(model.tf_id(3)),',',gene_names_std(model.tf_id(4)),') -> ',gene_names_std(model.trg_id)),'fontsize',14);
    end
        
    subplot(3,2,3);
    [AX,H1,H2] = plotyy(t,p3,t,p4);
    set(AX(1),'YColor','r');
    set(H1,'Color','r');
    set(AX(2),'YColor',[70 179 68]/255);
    set(H2,'Color',[70 179 68]/255);
    axis(AX(1),[0 205 0.9*min(p3) 1.1*max(p3)]);
    axis(AX(2),[0 205 0.9*min(p4) 1.1*max(p4)]);
    ylabel(AX(1),strcat('[',gene_names_std(model.tf_id(3)),'p]'),'fontsize',12);
    ylabel(AX(2),strcat('[',gene_names_std(model.tf_id(4)),'p]'),'fontsize',12);
    
    subplot(3,2,5);
    plot(t,synm_t);
    hold on;
    plot(t,trg_syn,'*');
    axis([0 205 0.9*min([trg_syn synm_t]) 1.1*max([trg_syn synm_t])]);
    ylabel(strcat(gene_names_std(model.trg_id),' acitivity'),'fontsize',12);
    xlabel('t [min]','fontsize',12);
    
    subplot(3,2,[4 6]);
    h=surf(pm3,pm4,synm_reg2);
    box on;
    set(h,'FaceColor','none','LineWidth',2,'EdgeColor','interp');
    hold on;
    tmp=1.1*max(max(max(synm_reg2)),max(trg_syn));
    axis([pm3(1) pm3(30) pm4(1) pm4(30) 0 tmp]);
    xlabel(strcat('[',gene_names_std(model.tf_id(3)),']'),'fontsize',12);
    ylabel(strcat('[',gene_names_std(model.tf_id(4)),']'),'fontsize',12);
    zlabel(strcat(gene_names_std(model.trg_id),' activity'),'fontsize',12);
    
else
    
    error('model structure not supported.')
 
end