function [] = plot_data(list)

global expr1;
global expr2;
global syn1;
global syn2;
global gene_names_sys;
global gene_names_std;

t=0:5:205;

for i=1:length(list)
    
    trg1 = syn1(list(i),:);
    trg2 = syn2(list(i),:);
    nans = isnan(trg1);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for k = 1:length(nans)
          if (nans(k)==0)
              tt(j) = t(k);
              xx(j) = trg1(k);
              j=j+1;
          end
       end
       trg1 = interp1(tt,xx,t,'spline');
    end
    
    nans = isnan(trg2);
    if (sum(nans)~=0)
       if (sum(nans) >= length(nans)-3)
           error('at least three values of target synthesis rate must not be NaN!');
       end
       tt = zeros(1,numel(nans(nans==0)));
       xx = tt;
       j=1;
       for k = 1:length(nans)
          if (nans(k)==0)
              tt(j) = t(k);
              xx(j) = trg2(k);
              j=j+1;
          end
       end
       trg2 = interp1(tt,xx,t,'spline');
    end
   
    figure('OuterPosition',[100 600 1000 500]);
    subplot(1,2,1);
    plot(t,expr1(list(i),:));
    hold on;
    plot(t,expr2(list(i),:),'r');
    axis tight;
    title(strcat(gene_names_sys{list(i)},' (',gene_names_std{list(i)},')'),'fontsize',16);
    ylabel('expression level','fontsize',16);
    xlabel('t','fontsize',16);
    legend({'replicate 1','replicate 2'},'FontSize',16);
    
    subplot(1,2,2);
    plot(t,trg1);
    hold on;
    plot(t,trg2,'r');
    axis tight;
    ylabel('synthesis rate','fontsize',16);
    xlabel('t','fontsize',16);
    legend({'replicate 1','replicate 2'},'FontSize',16);
    
end