function pt = protein_grid (tf,rep,Ngrid)

global expr1;
global expr2;

% time
t = 0:5:205;

%data
if (rep==1)
    tf_expr = expr1(tf,:);
elseif(rep==2)
    tf_expr = expr2(tf,:);
else
    error('argument rep must be 1, or 2.');
end

% fill in missing values
nans = isnan(tf_expr);
if (sum(nans)~=0)
   if (sum(nans) >= length(nans)-3)
       error('at least three values of target synthesis rate must not be NaN!');
   end
   tt = zeros(1,numel(nans(nans==0)));
   xx = tt;
   j=1;
   for i = 1:length(nans)
      if (nans(i)==0)
          tt(j) = t(i);
          xx(j) = tf_expr(i);
          j=j+1;
      end
   end
   tf_expr = interp1(tt,xx,t,'spline');
end

% compute grid
pt = zeros(Ngrid,42);
lb = log(2)/70; ub = log(2)/5;
lp = linspace(lb,ub,Ngrid);
for i=1:Ngrid
    p0 = set_p0(tf_expr,lp(i));
    pt(i,:) = protein_traj(tf_expr,t,p0,lp(i),lp(i));
end