function p = set_p0(m,lp,t)

p0=mean(m);
if (nargin == 2)
    t=0:5:205;
end
pt=protein_traj(m,t,p0,lp,lp);
tc=3*log(2)/lp;
ic = min([30 floor(tc/5)]);
if (ic < 1)
    ic=1;
end

t0 = -(ic-1)*5;

x=pt(ic:length(t));
y=fft(x);

N=length(y);

k=0:(N-1);
p=real((1/N)*y*exp(2*pi*1i*k'*t0/(5*N)));