function [t, m, p] = sim_network(netw,t_end,kos)

global expr1;
global expr2;
global m_cln;
global t_cln;
global cln_p;
global ko;
global gene_names_std;
global netz;

if (nargin < 3)
   kos = []; 
end

ko = kos;
netz = netw.netw;
tfs = netw.tfs;

t_grid = 0:t_end;

if (netw.use_cln)
    m_cln = netw.m_cln;
    t_cln = 0:5:205;
    cln_lp = netw.cln_lp;
    p0 = set_p0(m_cln,cln_lp,t_cln);
    cln_p = protein_traj(m_cln,t_cln,p0,cln_lp,cln_lp);
end

y0 = netw.y0;
for i = 1:length(ko)
   if (netw.rep == 1)
       y0(2*ko(i)-1) = mean(expr1(tfs(ko(i)),:));
       y0(2*ko(i)) = mean(expr1(tfs(ko(i)),:));
   else
       y0(2*ko(i)-1) = 0.001*mean(expr2(tfs(ko(i)),:));
       y0(2*ko(i)) = 0.001*mean(expr2(tfs(ko(i)),:));
   end
end

[t, sol] = ode45(@(t,y)netw_ode_ko(t,y),t_grid,y0);

m = zeros(length(t_grid),length(netz));
p = zeros(length(t_grid),length(netz));

for i=1:length(netz)
   m(:,i) = sol(:,2*i-1);
   p(:,i) = sol(:,2*i);
end

%%%%%%%%%%%%%%% PLOT
    
N = length(netz);
n_r = ceil(N/4);
figure('OuterPosition',[100 600 1500 1000]);

k=0;
for i = 1:n_r
  for j = 1:4
      k = k+1;
      subplot(n_r,4,k);
      plot(t,m(:,k),'r');
      hold on
      plot(t,p(:,k));
      axis([t(1) t(length(t)) 0.9*min([m(:,k)' p(:,k)']) 1.1*max([m(:,k)' p(:,k)'])])
      if (i == n_r)
          xlabel('t','fontsize',12);
      end

      if (k == 1)
         legend('mRNA','protein'); 
      end

      if (length(netz(k).tf_id) == 1)
        if (netz(k).logic==1)
            logic = 'ACT';
        elseif (netw(k).logic==2)
            logic = 'NOT';
        end
        tit = sprintf('%s <- %s (%s)',gene_names_std{tfs(k)},gene_names_std{tfs(netz(k).tf_id)},logic);
      else
        if (netz(k).logic==1)
            logic = 'A AND B';
        elseif (netz(k).logic==2)
            logic = 'A AND NOT B';
        elseif (netz(k).logic==3)
            logic = 'NOT A AND B';
        elseif (netz(k).logic==4)
            logic = 'A XOR B';
        elseif (netz(k).logic==5)
            logic = 'A OR B';
        elseif (netz(k).logic==6)
            logic = 'A NOR B';
        elseif (netz(k).logic==7)
            logic = 'A OR NOT B';
        elseif (netz(k).logic==8)
            logic = 'NOT A OR B';
        elseif (netz(k).logic==9)
            logic = 'A NAND B';
        elseif (netz(k).logic==10)
            logic = 'A EQ B';
        elseif (netz(k).logic==11)
            logic = 'A';
        elseif (netz(k).logic==12)
            logic = 'NOT A';
        elseif (netz(k).logic==13)
            logic = 'B';
        elseif (netz(k).logic==14)
            logic = 'NOT B';
        elseif (netz(k).logic==15)
            logic = 'TRUE';
        end 
        if (netz(k).tf_id(1)==-1)
            tf1 = 'cln2'; 
        else
            tf1 = gene_names_std{tfs(netz(k).tf_id(1))};
        end
        if (netz(k).tf_id(2)==-1)
            tf2 = 'cln2'; 
        else
            tf2 = gene_names_std{tfs(netz(k).tf_id(2))};
        end
        trg = gene_names_std{tfs(k)};
        if (length(netz(k).tf_id)==2)
           tit = sprintf('%s <- %s, %s (%s)',trg,tf1,tf2,logic); 
        else
           tit = sprintf('%s <- %s, %s, cln2 (%s + CLN2)',trg,tf1,tf2,logic); 
        end
      end
      title(tit,'fontsize',12);

      if (k == N)
          break;
      end
  end
end