function res = sim_network_fit_costs (par,y0,expr)

global netz;
global m_cln;
global t_cln;
global t_fit;
global cln_p;

if (~isempty(m_cln))
    cln_lp = par(end);
    p0 = set_p0(m_cln,cln_lp,t_cln);
    cln_p = protein_traj(m_cln,t_cln,p0,cln_lp,cln_lp);
end

k=1;
for i = 1:length(netz)
    
   netz(i).lambdaP = par(k); k=k+1;
   netz(i).lm = par(k); k=k+1;
   netz(i).b = par(k); k=k+1;
   netz(i).alpha_max = par(k); k=k+1;
   if (netz(i).n_tfs == 1)
      netz(i).K = par(k); k=k+1; 
      netz(i).n = par(k); k=k+1; 
   elseif (netz(i).n_tfs == 2)
      netz(i).K(1) = par(k); k=k+1;
      netz(i).K(2) = par(k); k=k+1;
      netz(i).n(1) = par(k); k=k+1;
      netz(i).n(2) = par(k); k=k+1;
   else
      netz(i).K(1) = par(k); k=k+1;
      netz(i).K(2) = par(k); k=k+1;
      netz(i).K(3) = par(k); k=k+1;
      netz(i).n(1) = par(k); k=k+1;
      netz(i).n(2) = par(k); k=k+1;
      netz(i).n(3) = par(k); k=k+1;
   end
    
end

t_grid = 0:5:t_fit;
[t m] = ode45(@(t,y)netw_ode(t,y),t_grid,y0);

m = m';

res = 0;
for i = 1:length(netz)
    
    d = m(2*i-1,:) - expr(i,1:(t_fit/5+1));
    res = res + (d*d')/var(expr(i,1:(t_fit/5+1)));
    
end

res = res / length(netz);