function [C] = rbcolors(nclasses)
   
%creates my own rainbow colormap

cmap = [0.5  0    0.8  ; ...
	0    0    1    ; ...
	0    0.4  1    ; ...
	0    0.7  1    ; ...
        0    1    1    ; ...
	0    1    0.7  ; ...
	0    1    0.4  ; ...
	0    1    0    ; ...
	0.25 0.975  0  ; ...
	0.5  0.95   0  ; ...
	0.75 0.925  0  ; ...
	1    0.9  0    ; ...
	1    0.8 0     ; ...
	1    0.6 0     ; ...
	1    0.4 0     ; ...
	1    0.2  0    ; ...
	0.9  0    0.1];

C = zeros(nclasses, 3);
Nr = size(cmap,1);

fac = (Nr-1)/(nclasses-1)
for i=1:nclasses,
  g = (i-1)*fac + 1;
  g2 = floor(g);
  g1 = g-floor(g);
  if g2<Nr,
    C(i,:) = (1-g1)*cmap(g2,:)+g1*cmap(g2+1,:);
  else
    C(i,:) = cmap(g2,:);
  end
end;
