function [X Y]=trajectory(x,y,T,um,pi,lim)

% Output: the figure of trajectories and corresponding data X (um), Y (um)

% Input
% x: X coord; y: Y coord; T: the number of trajectory or cell
% um: image size(um); pi: image size(pixel); lim: xlim ylim

for i=1:T
  inxy=find(isnan(x(:,i))==0,1,'first'); 
  x(:,i)=x(:,i)-x(inxy,i);
  y(:,i)=y(:,i)-y(inxy,i);
end

X=x*um/pi;%um
Y=y*um/pi;%um

plot(X,Y,'LineWidth',0.5);% trajectory
axis equal 
set(gca,'ydir','reverse','xaxislocation','top');
box off
xlabel('um');
ylabel('um');
xlim(lim);
ylim(lim);

end