function outcome = compete(communitiesData, i1i2, prop)
% start from half-sum of the two equilibria
k = (size(communitiesData,2)-2)/2;
abd = zeros(size(prop.cost));

% Make sure that #1 is the "more fit" community
if communitiesData(i1i2(2),end)>communitiesData(i1i2(1),end)
    i1i2 = i1i2([2 1]);
end

% Make sure this goes correctly even if the two sets overlap
sel1 = communitiesData(i1i2(1),1:k);
sel2 = communitiesData(i1i2(2),1:k);
abd1 = communitiesData(i1i2(1),k+(1:k))'/2;
abd2 = communitiesData(i1i2(2),k+(1:k))'/2;
if any(abd1==0)||any(abd2==0)
    notFullHouse = true;
end

abd(sel1) = abd1;
abd(sel2) = abd2 + abd(sel2);

outcome.types = union(sel1,sel2);
[~, ind1] = ismember(sel1,outcome.types);
[~, ind2] = ismember(sel2,outcome.types);

outcome.group(1).abd = 0*outcome.types;
outcome.group(1).abd(ind1) = abd1;
outcome.group(1).fitnessComm = communitiesData(i1i2(1),end);
outcome.group(1).fitnessIndPath = communitiesData(i1i2(1),end-2); % ignore!!
outcome.group(1).fitnessIndCost = communitiesData(i1i2(1),end-1);

outcome.group(2).abd = 0*outcome.types;
outcome.group(2).abd(ind2) = abd2;
outcome.group(2).fitnessComm = communitiesData(i1i2(2),end);
outcome.group(2).fitnessIndPath = communitiesData(i1i2(2),end-2); % ignore!!
outcome.group(2).fitnessIndCost = communitiesData(i1i2(2),end-1);

dThresh = 1e-5;
abd = equilibrateCommunity(abd, prop, dThresh);

% post-competition
outcome.merge.abd = abd(outcome.types)';
[outcome.merge.fitnessComm, outcome.merge.fitnessInd] = getCommunityFitness(abd,prop);

% Score the outcome
% Invaders: types that were in one community but NOT in the other, 
% and which are present in the final community.
thresh = 0.001;
present1 = outcome.group(1).abd>thresh;
present2 = outcome.group(2).abd>thresh;
presentMerge = outcome.merge.abd>thresh;

outcome.score = scoreOverlap(present1, present2, presentMerge);
end