function [abd, warn] = equilibrateCommunity(abd, prop, dThresh)
% Start: abundance vector abd
% Zero initial abundance means "strictly absent" and will not appear

if nargin<3
    dThresh = 1e-7;
end
warn = false;

include = abd>0;

% Types that are initially present at vanishing abundances can be a
% nuisance (will take a long time to "wake up" and mess up the system). So
% ensure that all the type we are simulating are present at non-negligible
% abundance to begin with.
abd(include)=max(abd(include), 0.1);

if isfield(prop, 'speciesStr')
    subprop = rmfield(prop,'speciesStr');
else
    subprop = prop;
end
subprop.enzymesInSpecies = subprop.enzymesInSpecies(include,:);
subprop.cost = subprop.cost(include);

odefun = @(t,y)evaluateDerivatives(y, subprop);

maxT = 10000;
errorGenerated = false;
iter = 0;
while (1)
    [t,y] = ode15s(odefun,[0,maxT], abd(include));
    final = y(end,:)';
    abd(include) = final;
    dydt = evaluateDerivatives(final, subprop);
    if max(abs(dydt))<dThresh
        break;
    else
        errorGenerated = true;
        maxT = maxT*10;
        iter=iter+1;
        if iter>5
            fprintf('\n');
            warning('Precision goal not reached. Aborting.');
            warn = true;
            break;
        else
            fprintf('Multiplying maxT by 10 and repeating... ');
        end
    end
end

if errorGenerated 
    fprintf('\n');
end
end
