function dydt = evaluateDerivatives(abd, prop, minAbd)
% extra option: do not let anyone's abundance fall below minAbd
totalEnzyme = prop.enzymesInSpecies' * abd + prop.offset;
totalEnzyme = max(totalEnzyme,1e-4);
% capacity of an enzyme: if it is a negative integer, it refers to another
% enzyme (capacity = total presence of that enzyme)
capacity = prop.capacity;
harvest = capacity ./ totalEnzyme;
dPhi = prop.enzymesInSpecies * harvest - prop.cost;
dydt = abd.*dPhi;
if nargin>2
    % for types with abundance below minAbd, only allow positive derivative
    lowAbd = abd<minAbd;
    dydt(lowAbd & dydt<0)=0;
end
end