function [invaders, dPhi, growth] = findInvaders(abd,prop, thresh)
% find all 0-abundance species with a positive dPhi

totalEnzyme = prop.enzymesInSpecies(abd>0,:)' * abd(abd>0) + prop.offset;
totalEnzyme = max(totalEnzyme,1e-4);

capacity = prop.capacity;
capacity(capacity<0) = totalEnzyme(-capacity(capacity<0))*prop.xi;
harvest = capacity ./ totalEnzyme;
dPhi = prop.enzymesInSpecies * harvest - prop.cost;

invaders = abd==0 & dPhi>0;
%invaders = dPhi>thresh*2; % *2 just in case

if nargout>2
    enzCount = sum(prop.enzymesInSpecies,2);
    %wouldBeHarvest = capacity ./ (totalEnzyme+1);
    growth = (prop.enzymesInSpecies * harvest - prop.cost)./enzCount;
end
end