function info = fullDynamicalSimulation(abd, prop, maxT)
% Start: abundance vector abd
% Zero initial abundance means "strictly absent" and will not appear

include = abd>0;

minAbd = min(abd(include));

if isfield(prop, 'speciesStr')
    subprop = rmfield(prop,'speciesStr');
else
    subprop = prop;
end
subprop.enzymesInSpecies = subprop.enzymesInSpecies(include,:);
subprop.cost = subprop.cost(include);

%odefun = @(t,y)evaluateDerivatives(y, subprop, minAbd);
odefun = @(t,y)evaluateDerivatives(y, subprop);

sol = ode15s(odefun,[0,maxT], abd(include));

% Prepare to calculate fitness sime series
if isfield(prop,'cpe')
    cpe = prop.cpe(include);
else
    enzCount = sum(prop.enzymesInSpecies(include,:),2);
    cpe = prop.cost(include)./enzCount;
end

abdTbl = sol.y;

% indPath = subprop.capacity(1) - (abdTbl'*cpe)'./sum(abdTbl);
% indCost = subprop.capacity(1)*(abdTbl'*(1./cpe))'./sum(abdTbl) - 1;
ind = -(abdTbl'*log(cpe))'./sum(abdTbl) ;
       
totalEnzyme = subprop.enzymesInSpecies' * abdTbl + repmat(prop.offset,[1 length(sol.x)]);
totalEnzyme = max(totalEnzyme,1e-4);
TR = totalEnzyme./repmat(subprop.capacity,[1,size(totalEnzyme,2)]);
comm = (subprop.capacity' * log(TR) - subprop.cost'*abdTbl)/sum(subprop.capacity)+1;

info.sol=sol;
% info.indPath = indPath;
% info.indCost = indCost;
info.ind = ind;
info.comm = comm;
info.t = sol.x;
end
