function [comm, ind] = getCommunityFitness(abd,prop)
% Calculate community fitness, and the individual fitness defined as -log(cpe)
sel = abd>0;
abd = abd(sel);
if isfield(prop,'cpe')
    cpe = prop.cpe(sel);
else
    enzCount = sum(prop.enzymesInSpecies(sel,:),2);
    cpe = prop.cost(sel)./enzCount;
end


% indPath = prop.capacity(1) - abd'*cpe/sum(abd);
% indCost = prop.capacity(1)*abd'*(1./cpe)/sum(abd) - 1;
% indHead = prop.capacity(1)*(abd'*enzCount -prop.N)/sum(abd);
ind = - abd'*log(cpe)/sum(abd);

totalEnzyme = prop.enzymesInSpecies(sel,:)' * abd + prop.offset;
totalEnzyme = max(totalEnzyme,1e-4);

comm = (prop.capacity' * log(totalEnzyme./prop.capacity) - prop.cost(sel)'*abd) / sum(prop.capacity)+1;
% comm = prop.capacity' * log(totalEnzyme) - sum(prop.capacity);
