function prop = init(N,generateStr)
if nargin<2
    generateStr=true;
end
% parameters
prop.k0 = 0;
prop.lambda = 0;
prop.dt = 0.1;
prop.capacity = 100*ones(N,1);
prop.offset = zeros(N,1);
prop.xi = 1;
prop.N = N;

% enzymesInSpecies
enzymesInSpecies = false(2^N-1, N);
k = 1:2^N-1;
for i=1:N
    thisBit = (k >= 2^(N-i));
    enzymesInSpecies(:,i) = thisBit;
    k = k - thisBit*(2^(N-i));
end
prop.enzCount = sum(enzymesInSpecies,2);

if generateStr
    speciesStr = zeros(2^N-1, N);
    for i=1:2^N-1
        speciesStr(i,1:prop.enzCount(i))=find(enzymesInSpecies(i,:));
    end
    speciesStr = speciesStr+double('A')-1;
    speciesStr(speciesStr==double('A')-1)=double(' ');
    speciesStr = char(speciesStr);
    prop.speciesStr = speciesStr;
else
    prop.speciesStr = [];
end
    
%% Combine into a structure of population properties.
prop.enzymesInSpecies = enzymesInSpecies;

% set to NaN, because this needs to be populated according to whatever cost
% model the invoking code wants to use
prop.cost = NaN(2^N-1,1); 
end
