function [ y, dy, miRprod] = CLEtimeseries( tau,v,Tend,timestep,parms )
%EULERFUNCTION Summary of this function goes here
%   Detailed explanation goes here

ttot = (Tend+tau)/timestep;
h = tau/timestep;
mup=parms.mup;
n=parms.n;  
p0=parms.p0;  
a1=parms.a1; 
a2=parms.a2;
p1=parms.p1; 
murr=parms.murr;
alphar=parms.alphar;
alphap=parms.alphap;
alpham=parms.alpham;
p2=parms.p2; 
n2=parms.n2;
n1=parms.n1;
p3=parms.p3; 
n3=parms.n3;
N=parms.N;

    
y = zeros(6,ttot);
dy = zeros(6,ttot);
miRprod = zeros(1,ttot);
hist = repmat(v,1,h);
y(:,1:h)=hist;
i = h+1;  


while i<ttot


ylag1 = y(2,(i-(h)) );
ylag2 = y(5,(i-(h)) );
m=y(1,(i-1));
p=y(2,(i-1));
r=y(3,(i-1));

M=y(4,(i-1))/N;
P=y(5,(i-1))/N;
R=y(6,(i-1))/N;
ylag2 = ylag2/N;

Gx = 1/(1+(ylag2/p0)^n);
Grx = 1/(1+(P/p3)^n3);
Fx = 1/(1+(R/p2)^n2);
Sx=(a1)+(a2-a1)/(1+((R)/p1)^n1);


rnds = randn(3,1);

dy(:,i) = [(alpham*(1+(ylag1/p0)^n)-((a1)+(a2-a1)./(1+((r)./p1).^n1))*m)*timestep;
                     (alphap*(1/(1+(r/p2)^n2))*m - mup*p)*timestep;
                     (alphar*(1/(1+(p/p3)^n3))-murr*r)*timestep;
                     N*(alpham*Gx - M*Sx)*timestep + (N^0.5)*(timestep^0.5)*real((Sx*M + alpham*Gx)^0.5)*rnds(1);
                     N*(Fx*alphap*M - mup*P)*timestep + (N^0.5)*(timestep^0.5)*real((mup*P + alphap*Fx*M)^0.5)*rnds(2);
                     N*(alphar*Grx - murr*R)*timestep + (N^0.5)*(timestep^0.5)*real((murr*R + alphar*Grx)^0.5)*rnds(3)];

y(:,i) = y(:,i-1) + dy(:,i);

miRprod(i) = N*(alphar*Grx);
                                                            
i = i+1;
end

t=timestep:timestep:Tend;
% Dist(j) = t(i);



end

