% set parameters - parameter set 2;

parms.mup = (log(2)/22); 
parms.n = 5; 
tau = 29; 
parms.p0=390;  
parms.a1=log(2)/20; 
parms.a2=log(2)/35;
parms.p1=80; 
parms.murr=log(2)/1000;
parms.alphar=1;
parms.alphap=2;
parms.alpham=1;
parms.p2=100; 
parms.n2=5;
parms.n1=5;
parms.p3=280; 
parms.n3=5;
Tend=5000;
parms.x1 = parms.a1;
parms.x2 = parms.a2;

%%

timestep = 0.1; % timestep of Euler-Maruyamam scheme

v=zeros(6,1);
v(1)=20; % set initial conditions
v(2)=400;
v(3) = 0.00001;

%Create data for Figure 5A
Nvec = [5] %System size
for i = 1:length(Nvec);
    
    parms.N = Nvec(i);
    v(4) = parms.N*v(1);
    v(5) = parms.N*v(2);
    v(6) = parms.N*v(3);

    [y,dy,miRprod]  = CLEtimeseries( tau,v,Tend,timestep,parms );
    
    h = tau/timestep;
    y(:,[1:h])=[];
    dy(:,[1:h])=[];
    miRprod(:,[1:h])=[];
    
    Mvec2(i,:) = y(4,:);
    Pvec2(i,:) = y(5,:);
    Rvec2(i,:) = y(6,:);
    
    dRvec2(i,:) = miRprod;
    
end

m=y(1, :);
p=y(2, :);
r=y(3, :);

t=timestep:timestep:Tend;

disp('done CLE system size 5')

%Create data for Figure 5B

parms.N = 1; % system size
v=zeros(6,1);
v(1)=20; % set initial conditions
v(2)=400;
v(3) = 0.00001;

Nvec = [1];
for i = 1:length(Nvec);
    
    parms.N = Nvec(i);
    v(4) = parms.N*v(1);
    v(5) = parms.N*v(2);
    v(6) = parms.N*v(3);

    [y,dy,miRprod]  = CLEtimeseries( tau,v,Tend,timestep,parms );
    
    h = tau/timestep;
    y(:,[1:h])=[];
    dy(:,[1:h])=[];
    miRprod(:,[1:h])=[];
    
    Mvec1(i,:) = y(4,:);
    Pvec1(i,:) = y(5,:);
    Rvec1(i,:) = y(6,:);
    
    dRvec1(i,:) = miRprod;
    
end

m=y(1, :);
p=y(2, :);
r=y(3, :);

t=timestep:timestep:Tend;

disp('done CLE system size 1')

%%
%Create data for Figure 5C
% create time-differentiation when parameters changed
DefaultParams_nonDim
parms.alphar = 0.25;
parms.p3 = 700;
totalreps = 2000; %Normally thiswould change if running multiple jobs locally

Nvec = [1, 5, 50];


for i=1:length(Nvec)
N = Nvec(i)
mstart = 20*N; % initial conditions
pstart = 400*N;
rstart = 0;

% note end point now at r>170
[ dist ] = GillespieTiming_Mod8(N,parms,totalreps,mstart, pstart,rstart, tau); 
distTOT(i,:) = dist;


end

distGillespie = distTOT;
disp('done gillespie')
% save alphar025pe700r170
%%

load alphar025pe700r170;%load timing data used in paper

[bandwidth,density1a,xmesh1a,cdf]=kde((distGillespie(1,:)));

[bandwidth,density2a,xmesh2a,cdf]=kde((distGillespie(2,:)));

[bandwidth,density3a,xmesh3a,cdf]=kde((distGillespie(3,:)));

%%
% plot data
figure()
subplot(3,1,2)
[AX,H1,H2] = plotyy(t,Pvec1(1,:),t,dRvec1(1,:));
hold on
plot(t,Rvec1(1,:),'color','r')
ylim([0 1500])
% xlim([0 Tend])
set(AX(2),'YLim',[0 3])
% set(AX(1),'YLim',[0 7500])
xlabel('Time (mins)')
set(get(AX(1),'Ylabel'),'String','Molecule number') 
set(get(AX(2),'Ylabel'),'String','Production of miR-9 (mins^{-1})')
set(H1,'color',[0 0.5 0])
set(H2,'color','b')
% set(H2,'LineStyle',':')
set(AX,{'ycolor'},{'k';'k'})
% LineStyleOrder 
set(AX,{'ycolor'},{'k';'b'})
set(AX,{'xlim'},{[0 Tend];[0 Tend]})
title('\Omega = 1')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.05*(b(2)-b(1)),{'B'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')


subplot(3,1,1)
[AX,H1,H2] = plotyy(t,Pvec2(1,:),t,dRvec2(1,:));
hold on
plot(t,Rvec2(1,:),'color','r')
ylim([0 7500])
% xlim([0 Tend])
set(AX(2),'YLim',[0 5*3])
xlabel('Time (mins)')
set(get(AX(1),'Ylabel'),'String','Molecule number') 
set(get(AX(2),'Ylabel'),'String','Production of miR-9 (mins^{-1})')
set(H1,'color',[0 0.5 0])
set(H2,'color','b')
% set(H2,'LineStyle',':')
set(AX,{'ycolor'},{'k';'b'})
set(AX,{'xlim'},{[0 Tend];[0 Tend]})
title('\Omega = 5')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.05*(b(2)-b(1)),{'A'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
% text(a(1)-0.1*(a(2)-a(1)),1200,{'a)'},...
%     'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

subplot(3,1,3)
plot(xmesh3a,density3a)
hold on
plot(xmesh2a,density2a,'color','r')
hold off
hold on
plot(xmesh1a,density1a,'color','k')
hold off
xlabel('Time (mins)')
ylabel('Probability of differentiation')
xlim([0 2000])
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.05*(b(2)-b(1)),{'C'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
legend('\Omega = 50','\Omega = 5','\Omega = 1')