% can use parallel function to speed up
% set (findResource(), 'ClusterSize', 4)
% matlabpool open 4
%%
% set parameters - parameter set 2

parms.mup = (log(2)/22); 
parms.n = 5; 
tau = 29; 
parms.p0=390;  
parms.x1=log(2)/20; 
parms.x2=log(2)/35;
parms.a1 = parms.x1;
parms.a2 = parms.x2;
parms.p1=80; 
parms.murr=log(2)/1000;
parms.alphar=1;
parms.alphap=2;
parms.alpham=1;
parms.p2=100; 
parms.n2=5;
parms.n1=5;
parms.p3=280; 
parms.n3=5;



%%

v=zeros(6,1);
v(1)=20; % set initial conditions
v(2)=400;
v(3) = 0.00001;

Tend=10000;
timestep = 0.1; 
Nvec = [1];
totalreps = 2000;


for i = 1:length(Nvec);
    i
    parms.N = Nvec(i);
    v(4) = parms.N*v(1);
    v(5) = parms.N*v(2);
    v(6) = parms.N*v(3);
tic
    [ Dist] = CLEoptTIMINGwhile( tau,v,Tend,timestep,parms,totalreps );
    toc
    distTOT(i,:) = Dist;

    
end

distMIR1 = distTOT;

distMIR1 = distMIR1 - tau;

%%

v=zeros(6,1);
v(1)=20;
v(2)=400;
v(3) = 40;

for i = 1:length(Nvec);
    i
    parms.N = Nvec(i);
    v(4) = parms.N*v(1);
    v(5) = parms.N*v(2);
    v(6) = parms.N*v(3);
tic
    [ Dist] = CLEoptTIMINGwhile( tau,v,Tend,timestep,parms,totalreps );
    toc
    distTOT(i,:) = Dist;

    
end

distMIR2 = distTOT;

distMIR2 = distMIR2 - tau;

%%


v=zeros(6,1);
v(1)=20;
v(2)=400;
v(3) = 80;

for i = 1:length(Nvec);
    i
    parms.N = Nvec(i);
    v(4) = parms.N*v(1);
    v(5) = parms.N*v(2);
    v(6) = parms.N*v(3);
tic
    [ Dist] = CLEoptTIMINGwhile( tau,v,Tend,timestep,parms,totalreps );
    toc
    distTOT(i,:) = Dist;


    
end

distMIR3 = distTOT;

distMIR3 = distMIR3 - tau;

%%
% load FIGURE6 to reproduce exact from paper

subplot(2,3,1)
hist(distMIR1)
xlim([0 4000])
title('Initial miR-9 = 0');%. Mean =',num2str(mean(distMIR1),3),'. \sigma= ',num2str(std(distMIR1),3)])
ylim([0 1000])
xlabel('Time (mins)')
ylabel('Frequency')
text(1600,800,{['mean = ',num2str(mean(distMIR1),'%.0f')];['\sigma = ',num2str(std(distMIR1),3)]})
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'A'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
subplot(2,3,2)
hist(distMIR2)
xlim([0 4000])
title(['Initial miR-9 = 40']);%. Mean =',num2str(mean(distMIR2),3),'. \sigma= ',num2str(std(distMIR2),3)])
ylim([0 1000])
xlabel('Time (mins)')
ylabel('Frequency')
text(1600,800,{['mean = ',num2str(mean(distMIR2),'%.0f')];['\sigma = ',num2str(std(distMIR2),3)]})
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'B'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
subplot(2,3,3)
hist(distMIR3)
xlim([0 4000])
title(['Initial miR-9 = 80']);%. Mean =',num2str(mean(distMIR3),3),'. \sigma= ',num2str(std(distMIR3),3)])
ylim([0 1000])
xlabel('Time (mins)')
ylabel('Frequency')
text(1600,800,{['mean = ',num2str(mean(distMIR3),'%.0f')];['\sigma = ',num2str(std(distMIR3),3)]})
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'C'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')



load TimingSpread
x = [72; 96; 120; 144; 168; 192; 216]; % times - hours

Control = TimingSpread(:,1:4); % contrl experiment - 4 experiments
y = Control;
Avg = mean(y,2);
subplot(2,3,4)
Err = std(y,[],2)/sqrt(4);
bar(x,Avg,'c')
hold on
errorbar(x,Avg,zeros(size(x)),Err,'k.','MarkerSize',1)
hold off
title('Control')
ylim([ 0 20])
xlabel('Time (hours)')
ylabel('% newly differentiated cells');% (% of total at that time)')
% text(142,15,'\sigma = 48')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'D'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

miR50 = TimingSpread(:,6:8); % with 50 nm miR-9 - 3 experiments
y = miR50;
Avg = mean(y,2);
subplot(2,3,5)
Err = std(y,[],2)/sqrt(3);
bar(x,Avg,'c')
hold on
errorbar(x,Avg,zeros(size(x)),Err,'k.','MarkerSize',1)
hold off
title('50nM miR-9')
xlabel('Time (hours)')
% text(142,15*(15/20),'\sigma = 24')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'E'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

miR100 = TimingSpread(:,11:12); % with 100 nm miR-9 - 2 experiments
y = miR100;
Avg = mean(y,2);
subplot(2,3,6)
Err = std(y,[],2)/sqrt(2);
bar(x,Avg,'c')
hold on
errorbar(x,Avg,zeros(size(x)),Err,'k.','MarkerSize',1)
hold off
title('100nM miR-9')
xlabel('Time (hours)')
% text(142,15,'\sigma = 17')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'F'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

