% note this figure uses the DDE-BIFTOOL

% reference: Engelborghs, K., Luzyanina, T., and Roose, D. (2002). Numerical bifurcation analysis of delay differential
% equations using DDE-BIFTOOL. ACM Transactions on Mathematical Software, 28(1):121.

[name,n]=sys_init
%%
DefaultParams_nonDim

stst.kind='stst';
stst.parameter=[par(1) par(2) par(3) par(4) par(5) par(6) par(7) par(8) par(9) par(10) par(11) par(12) par(13) par(14) par(15) 29 ];
stst.x= [34.99 58.35 360.6]';%[20 350 280]'
flag_newhheur=1;

method=df_mthod('stst',flag_newhheur);

method.stability.minimal_real_part=-2;

nend =  120;

n2Vec = linspace(1,5,nend);
P2Vec = linspace(200,1000,nend); 
stabgrid = zeros(nend,nend);
successgrid = zeros(nend,nend);
Cohergrid = zeros(nend,nend);
ststgrid = zeros(nend,nend);
ststcheck = zeros(nend,nend);

% tic

for i = 1:nend
    disp(i)
    for j = 1:nend
%         disp(j)
        par(8) = P2Vec(i);
        par(9) = n2Vec(j);
        [ Coher,EndVal ] = GetCoherence( par );
        Cohergrid(i,j) = Coher;
        stst.x= [EndVal]';
        stst.parameter=[par(1) par(2) par(3) par(4) par(5) par(6) par(7) P2Vec(i) n2Vec(j) par(10) par(11) par(12) par(13) par(14) par(15) 29 ];%[390 5 MurVec(i) 0.0315 1 alphapVec(j) 29];
        [stst,success]=p_correc(stst,[],[],method.point);
        ststgrid(i,j) = stst.x(2);
        ststcheck(i,j) = EndVal(2); % check correction has worked
        successgrid(i,j)=success;
        stst.stability=p_stabil(stst,method.stability);
        stabgrid(i,j) = stst.stability.l1(1);       
    end
%     disp(i)
end

% toc
%%

RealGrid = real(stabgrid);
ImagGrid = imag(stabgrid);

A1 = (RealGrid>0);
B = Cohergrid;
C = (RealGrid<0);
D1 = (B).*C;
% save('Fig6')

%%
load Fig6

pointn2_1 = 3.5;
pointp2_1 = 900;

pointn2_2 = 3.5;
pointp2_2 = 600;

pointn2_3 = 1.3;
pointp2_3 = 600;
% 
%%

subplot(4,2,2)
k = imagesc(n2Vec,P2Vec,max(max(D1))*A1+D1); %changed from just D1
set(gca, 'YDir', 'normal')
cbh = colorbar;

set(cbh,'YTick',0:0.1:0.3)
set(cbh,'YTickLabel',{'0','10','20','30'})
% set(gca,'FontSize',18)
% xlabel('n_2')
% ylabel('P_2')
xlabel('r_1')
ylabel('m_1')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'B'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

text(1.05,750,{'Stochastic oscillations'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_1+0.05,pointp2_1-25,{'1'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_2,pointp2_2,{'2'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_3,pointp2_3,{'3'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')



%%
subplot(4,2,1)
k = imagesc(n2Vec,P2Vec,A1);
set(gca, 'YDir', 'normal')

% set(gca,'FontSize',18)
% xlabel('n_2')
% ylabel('P_2')
xlabel('r_1')
ylabel('m_1')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'A'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')

text(2.4,400,{'No oscillations'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')
text(2.4,875,{'Oscillations'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_1+0.05,pointp2_1-25,{'1'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_2,pointp2_2,{'2'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')

text(pointn2_3,pointp2_3,{'3'},...
    'FontSize',9,'HorizontalAlignment','left', 'VerticalAlignment','bottom','color','w')



%%


DefaultParams_nonDim
parms.n2 = pointn2_1;
parms.p2 = pointp2_1;
N = 1;%5;% 50];
Tend = 12000;
Output_Times = 0:5:Tend;
totalreps = 1;

mstart = 20*N; % initial conditions
pstart = 400*N;
rstart = 0;

[ mout,pout,rout ] = GillespieTiming(N,parms,totalreps,mstart, pstart, rstart, tau,Output_Times); 

subplot(4,2,4)
plot(Output_Times,pout,'color',[0 0.5 0])
hold on
plot(Output_Times,rout,'color','r')
hold off
ylabel('Molecule number')
% ylim([0 6000])
xlim([0 10000])
xlabel('Time (mins)')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'D'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')



tau = [29];
options=ddeset('RelTol',1e-5);
sol = dde23(@Delay,tau,@history,[0, Tend],[options],parms);
subplot(4,2,3)
plot(sol.x,N*sol.y(2,:),'color',[0 0.5 0])
hold on
plot(sol.x,N*sol.y(3,:),'color','r')
hold off
xlim([0 10000])
xlabel('Time (mins)')
ylabel('Scaled expression')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'C'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
text(a(1)-0.25*(a(2)-a(1)),b(2)/2,{'1'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
% legend('Hes1 protein','miR-9')


%%



DefaultParams_nonDim
parms.n2 = pointn2_2;
parms.p2 = 800;%pointp2_2;
parms.p3 = 390;
N = 1;%5;% 50];
Tend = 12000;
Output_Times = 0:5:Tend;
totalreps = 1;

mstart = 20*N; % initial conditions
pstart = 400*N;
rstart = 0;
v = [20;400;0];

[ mout,pout,rout ] = GillespieTiming(N,parms,totalreps,mstart, pstart, rstart, tau,Output_Times); 

subplot(4,2,6)
plot(Output_Times,pout,'color',[0 0.5 0])
hold on
plot(Output_Times,rout,'color','r')
hold off
ylabel('Molecule number')
% ylim([0 6000])
xlim([0 10000])
xlabel('Time (mins)')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'F'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')


tau = [29];
options=ddeset('RelTol',1e-5);
sol = dde23(@Delay,tau,v,[0, Tend],[options],parms);
subplot(4,2,5)
plot(sol.x,N*sol.y(2,:),'color',[0 0.5 0])
hold on
plot(sol.x,N*sol.y(3,:),'color','r')
hold off
xlim([0 10000])
xlabel('Time (mins)')
ylabel('Scaled expression')
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'E'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
text(a(1)-0.25*(a(2)-a(1)),b(2)/2,{'2'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')


%%

DefaultParams_nonDim
parms.n2 = pointn2_3;
parms.p2 = pointp2_3;
N = 1;%5;% 50];
Tend = 12000;
Output_Times = 0:5:Tend;
totalreps = 1;

mstart = 20*N; % initial conditions
pstart = 400*N;
rstart = 0;
v = [20;400;0];

[ mout,pout,rout ] = GillespieTiming(N,parms,totalreps,mstart, pstart, rstart, tau,Output_Times); 

subplot(4,2,8)
plot(Output_Times,pout,'color',[0 0.5 0])
hold on
plot(Output_Times,rout,'color','r')
hold off
xlabel('Time (mins)')
ylabel('Molecule number')
% ylim([0 6000])
xlim([0 10000])
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'H'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')


tau = [29];
options=ddeset('RelTol',1e-5);
sol = dde23(@Delay,tau,v,[0, Tend],[options],parms);
subplot(4,2,7)
plot(sol.x,N*sol.y(2,:),'color',[0 0.5 0])
hold on
plot(sol.x,N*sol.y(3,:),'color','r')
hold off
xlabel('Time (mins)')
ylabel('Scaled expression')
xlim([0 10000])
a = xlim();
b = ylim();
text(a(1)-0.1*(a(2)-a(1)),b(2)+0.1*(b(2)-b(1)),{'G'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
text(a(1)-0.25*(a(2)-a(1)),b(2)/2,{'3'},...
    'FontSize',9,'HorizontalAlignment','right', 'VerticalAlignment','bottom','color','k')
