function [ Amp, EndVal ] = GetAmplitude( parms )

tau = 29;
% parms.p2 = 800;
% parms.p1 = 20000;
% parms.n2 = 2;
% parms.n1 = 2;

%%
yInit(1) = 30;
yInit(2) = parms.p2;
yInit(3) = 1; 
Tend = 100000;

[ EndVal ] = FinalSteadyODE(yInit, Tend, parms);

%%
M = EndVal(1);
P = EndVal(2);
R = EndVal(3);
G = parms.alpham/(1 + (EndVal(2)/parms.p0)^parms.n);
Gd =  -parms.alpham*(parms.n/P)*((P/parms.p0)^parms.n)/(1+(P/parms.p0)^parms.n)^2;
S = parms.a1 + (parms.a2-parms.a1)/(1+(EndVal(3)/parms.p1)^parms.n1);
Sd = -(parms.a2-parms.a1)*(parms.n1/R)*((R/parms.p1)^parms.n1)/(1+(R/parms.p1)^parms.n1)^2;
F = (parms.alphap)/(1 + (EndVal(3)/parms.p2)^parms.n2);
Fd =  -parms.alphap*(parms.n2/R)*((R/parms.p2)^parms.n2)/(1+(R/parms.p2)^parms.n2)^2;
Gr = parms.alphar/(1 + (EndVal(2)/parms.p3)^parms.n3);
Grd =  -parms.alphar*(parms.n3/P)*((P/parms.p3)^parms.n3)/(1+(P/parms.p3)^parms.n3)^2;


%%
syms w real
a11 = -S;
a12 = parms.alpham * Gd * exp(-i*w*tau);
a13 = - Sd * M ;
a21 = parms.alphap * F;
a22 = -parms.mup;
a23 = parms.alphap * Fd * M;
a31 = 0;
a32 = parms.alphar * Grd;
a33 = -parms.murr ;

A = [i*w - a11, -a12, -a13;
     -a21, i*w - a22, -a23;
     -a31, -a32, i*w - a33];

detA = det(A);
% detAdetAconj = detA*conj(detA);
detAdetAconj = (abs(detA))^2;

%%
 
a = [ - a23, -a21; i*w - a33, -a31];
b = [ i*w - a11, -a13; -a31, i*w - a33];
c = [ -a13, i*w - a11; -a23, -a21];

x = (abs(det(a)))^2;
y = (abs(det(b)))^2;
z = (abs(det(c)))^2;

etam2= S*M + parms.alpham*G;
etap2 = parms.mup*P + parms.alphap*F*M;
etar2 = parms.murr*R + parms.alphar*Gr;

PXip = (1/detAdetAconj)*(x*etam2 + y*etap2 + z*etar2);


%%
% omega = [ 0:0.00005:0.12];
omega = linspace(0,0.12,100);

for n = 1:length(omega)
    XipTemp = PXip;
    XipTemp = subs(XipTemp,{w},{omega(n)});
    y(n) = XipTemp;
end
y = double(y);
Amp = findpeaks(y);

if isempty(Amp)
    Amp = 0;
end
% %%
% figure()
% plot(omega,y)
% xlabel('Angular frequency')
% ylabel('Power')
% % plot(w,log(y))
end

