function [ Coher,EndVal ] = GetCoherence( par )

tau = 29;
% par(8) = 800;
% par(7) = 20000;
% par(9) = 2;
% par(6) = 2;

%%
yInit(1) = 12;
yInit(2) = 550;
yInit(3) = 2000; 
Tend = 100000;

[ EndVal ] = FinalSteadyODE(yInit, Tend, par);

%%
M = EndVal(1);
m = M;
P = EndVal(2);
R = EndVal(3);
G = par(1)/(1 + (EndVal(2)/par(2))^par(3));
Gd =  -par(1)*(par(3)/P)*((P/par(2))^par(3))/(1+(P/par(2))^par(3))^2;
Sr = par(4) + (par(5)-par(4))/(1+(EndVal(3)/par(7))^par(6));
Sd = -(par(5)-par(4))*(par(6)/R)*((R/par(7))^par(6))/(1+(R/par(7))^par(6))^2;
F = (par(11))/(1 + (EndVal(3)/par(8))^par(9));
Fd =  -par(11)*(par(9)/R)*((R/par(8))^par(9))/(1+(R/par(8))^par(9))^2;
Gr = par(12)/(1 + (EndVal(2)/par(13))^par(14));
Grd =  -par(12)*(par(14)/P)*((P/par(13))^par(14))/(1+(P/par(13))^par(14))^2;


%%
% syms w real
% a11 = -S;
% a12 = par(1) * Gd * exp(-1i*w*tau);
% a13 = - Sd * M ;
% a21 = par(11) * F;
% a22 = -par(10);
% a23 = par(11) * Fd * M;
% a31 = 0;
% a32 = par(12) * Grd;
% a33 = -par(15);
% 
% A = [1i*w - a11, -a12, -a13;
%      -a21, 1i*w - a22, -a23;
%      -a31, -a32, 1i*w - a33];
% 
% detA = det(A);
% % detAdetAconj = detA*conj(detA);
% detAdetAconj = (abs(detA))^2;
% 
% %%
%  
% a = [ - a23, -a21; 1i*w - a33, -a31];
% b = [ 1i*w - a11, -a13; -a31, 1i*w - a33];
% c = [ -a13, 1i*w - a11; -a23, -a21];
% 
% x = (abs(det(a)))^2;
% y = (abs(det(b)))^2;
% z = (abs(det(c)))^2;
% 
% etam2= S*M + par(1)*G;
% etapar(8) = par(10)*P + par(11)*F*M;
% etar2 = par(15)*R + par(12)*Gr;
% 
% PXip = (1/detAdetAconj)*(x*etam2 + y*etapar(8) + z*etar2);
% 
% 
% %%
% % omega = [ 0:0.00005:0.12];
% % omega = linspace(0,0.12,100);
% omega = linspace(0,1,100000);
% 
% for n = 1:length(omega)
%     XipTemp = PXip;
%     XipTemp = subs(XipTemp,{w},{omega(n)});
%     y(n) = XipTemp;
% end
% 
% 
% y = double(y);


%%


min = 0;
max = 1;
samples = 10000;
w = linspace(min,max,samples);
S =zeros(3,3,length(w));
%%

for i = 1:length(w)
    
    %%
    a11 = -Sr;
    a12 = par(1) * Gd * exp(-1i*w(i)*tau);
    a13 = - Sd * m ;
    a21 = par(11) * F;
    a22 = -par(10);
    a23 = par(11) * Fd * m;
    a31 = 0;
    a32 = par(12) * Grd;
    a33 = -par(15);
    
    %%
    Jacobian = [1i*w(i) - a11, -a12, -a13;
             -a21, 1i*w(i) - a22, -a23;
             -a31, -a32, 1i*w(i) - a33];
         
         %%
    
%     Jacobian = [ S , - Gd*exp(-1i*w(i)*tau),Sd; -alphap, mup,0,0;
%         0,- J2*G1*exp(-1i*w(i)*par(10)),mum ,- J1*G2*exp(-1i*w(i)*par(7)) ; 0,0, -alphap, mup];
    
    M = Jacobian + eye(3)*1i*w(i);
    
    %%

    B = zeros(3,3);
    B(1,1) = Sr*m + par(1)*G;
    B(2,2) = par(10)*P + par(11)*F*m;
	B(3,3) = par(15)*R + par(12)*Gr;
%     B(1,1) = G1*G2 + mum*smm;
%     B(2,2) = mup*spp + alphap*smm;
%     B(3,3) = G1*G2 + mum*smm;
%     B(4,4) = mup*spp + alphap*smm;

    S(:,:,i) = (M)\B/(M');

end

pspec1 = real(squeeze(S(2,2,:)));

%%


[Amp,j] = findpeaks(pspec1);

if isempty(Amp)
    Coher = 0;
end

x1 = j - 0.1*j;
x1 = round(x1);
x2 = j + 0.1*j;
x2 = round(x2);

y = pspec1;

TotArea = trapz(w,y);



CoherArea = trapz(w(x1:x2),y(x1:x2));

Coher = CoherArea/TotArea;
% %%
% figure()
% plot(omega,y)
% xlabel('Angular frequency')
% ylabel('Power')
% % plot(w,log(y))
end