## script for analyzing microarray and RAN-seq data for the RNA-seq ms.
## please install required R packages before running the scripts.
#source("http://bioconductor.org/biocLite.R")
#biocLite("pbkrtest");
#biocLite("edgeR");
#biocLite("Agi4x44PreProcess");
#citation("Agi4x44PreProcess")
#library("Agi4x44PreProcess") ## only for R 3.0.1 version
#library(limma)
#library(sva);
#library(WGCNA)
#library(cluster)
#library(gplots)
#library(Biobase)
#library(ctc)
#library(plyr)
#library(quantreg)
#library(scales)
#library(reshape2)
#library(vcd)
#library(sjPlot)
#library(pbkrtest)


############################################################################################
## analyze RNA-seq data;
############################################################################################
#path="/home/sxu";
setwd(path); #please change this to your own directory

################################################################################
## load data;
################################################################################
rm(list = ls())
## please note the loading for sva package is currently disabled.
## please load the sva package seperately;
source("SourceCode/SubFunction_all.R"); ## load all subfunctions;



source("SourceCode/LoadRNAseqData.R"); ## load RNA-seq data
source("SourceCode/LoadAnnotation.R"); ## load gene annotation information
head(data.count.WWFAC);
head(data.count.FPKM.WWFAC);
nrow(data.count.WWFAC);

################################################################################
######## Perform analysis for FAC-induced responses               ##############
################################################################################

source("SourceCode/DE_analysis.R"); ## differential expression analysis for all species;

################################################################################
## Identifying and characterizing HAE-induced gene co-expression network
################################################################################

## optional, since the microarray data were pre-analyzed and data were saved;
#source("AnalyzeArray.R"); ## analyse microarray data in WT and irAOC;

source("Scripts/IdentifyGeneModule.R") ## identify the M4 module;
source("Scripts/Characterise_Module.R") ## characterise the M4 module;


################################################################################
## chacaterize gene duplication history:
################################################################################
source("Scripts/AnalyseDuplicationAndMITEs.R");

