## this script includes all subfunctions;
#library(limma)
rm(list = ls())
#library(mgcv)
#library(sva);
#source("http://bioconductor.org/biocLite.R")
library(WGCNA)
library(cluster)
library(gplots)
library(ctc)
library(plyr)
library(quantreg)
library(scales)
library(reshape2)
library(mvtnorm);
library(pbkrtest)
library("proxy");
#library(vcd)
#library(sjPlot)
#detach(sva,unload = T);
#remove.packages()
#detach("package:sva",unload = T);
#unloadNamespace("sva")

SigGeneFinder<-function(data=NULL,p=0.05,subset.s="*",logFC=1,cutoff=5, pair="WW|FAC",reg="up", allresults=F){
  data<-data;
  data.sub<-data[,grep(subset.s,colnames(data))];
  data.sub<-data.sub[,grep(pair,colnames(data.sub))];
  pair.s<-strsplit(pair,"\\|");
  
  conditions = factor(c(rep(pair.s[[1]][1], 3), rep(pair.s[[1]][2], 3)))
  data.sub = round(data.sub)
  data.sub = data.sub[rowSums(data.sub)>=cutoff,];
  exp_study = DGEList(counts=data.sub, group=conditions)
  #head(data.all.Nat);
  exp_study = calcNormFactors(exp_study)
  exp_study = estimateCommonDisp(exp_study)
  exp_study = estimateTagwiseDisp(exp_study)
  et = exactTest(exp_study)
  ?exactTest
  tTags = topTags(et,n=NULL)
  #write.table(tTags, file='FAC_induced_gene_in_Natt.txt', sep='\t', quote=F, row.names=T);
  #head(tTags$table);
  if (allresults){
    return (tTags$table)
  }
  else{
    if(reg=="up"){
      gene.sig<-row.names(tTags$table)[tTags$table$FDR<=0.05 & tTags$table$logFC>=logFC &  tTags$table$PValue<=p];
    }else{
      gene.sig<-row.names(tTags$table)[tTags$table$FDR<=0.05 & tTags$table$logFC<=(0-logFC) &  tTags$table$PValue<=p];
    }
    return(gene.sig);
  }
}


WGCNA.power<-function(data=NULL){
  # data=data.all.clean.Nob;
  
  outlier=FALSE;
  data.t<-as.data.frame(t(data));
  names(data.t)<-row.names(data);
  row.names(data.t)<-colnames(data);
  
  ## sample network: check outliers;
  A=adjacency(t(data.t),type="distance") ;
  k=as.numeric(apply(A,2,sum))-1
  Z.k=scale(k) 
  thresholdZ.k=-2.5
  if (min(Z.k) < thresholdZ.k){
    outlier=TRUE;
  }
  powers=c(1:30)
  
  sft=pickSoftThreshold(data.t,powerVector=powers);
  
  par(mfrow=c(1,2)) ;
  plot(sft$fitIndices[,1],-sign(sft$fitIndices[,3])*sft$fitIndices[,2], 
       xlab="Soft Threshold (power)",ylab="SFT, signed R^2",type="n",main=paste("Scale independence")) 
  text(sft$fitIndices[,1],-sign(sft$fitIndices[,3])*sft$fitIndices[,2], 
       labels=powers,col="red");
  abline(h=0.90,col="red") 
  
  plot(sft$fitIndices[,1],sft$fitIndices[,5],type="n", 
       xlab="Soft Threshold (power)",ylab="Mean Connectivity",main=paste("Mean connectivity")) 
  text(sft$fitIndices[,1],sft$fitIndices[,5],labels=powers,col="red") 
  return (outlier);  
}

WGCNA.plot<-function(data=NULL,power=NULL,filename=NULL,TOM=FALSE,plotPDF=FALSE,padjust=TRUE,logTrait=FALSE,deepsplit=2,JAmax=F,phenotype=NULL){
  if(!is.numeric(power) ){
    power=30;
  }
  data<-data; 
  if (JAmax){
    JAtype="Jamax";
  }else{
    JAtype="JA";
  }
  
  if(logTrait){
    phenotype<-log(phenotype[colnames(data),JAtype]);
  }
  else{
    phenotype<-phenotype[colnames(data),JAtype];
  }
  #head(phenotype)
  #data<-data.all.clean.4spe
  data.t<-as.data.frame(t(data));
  names(data.t)<-row.names(data);
  row.names(data.t)<-colnames(data);
  
  mergingThresh = 0.25 ;
  net = blockwiseModules(data.t,corType="pearson", 
                         maxBlockSize=5000,networkType="unsigned",power=power,minModuleSize=25,
                         mergeCutHeight=mergingThresh,numericLabels=TRUE,saveTOMs=TRUE, 
                         pamRespectsDendro=FALSE,saveTOMFileBase="WGCNA",deepSplit=deepsplit); 
  
  moduleLabelsAutomatic=net$colors;
  moduleLabelsAutomatic.num<-moduleLabelsAutomatic;
  moduleColorsAutomatic = labels2colors(moduleLabelsAutomatic);
  MEsAutomatic=net$MEs ;
  data.trait.GS=as.numeric(cor(data.t,phenotype,use="p")) ;
  GeneSignificance=(data.trait.GS);
  ModuleSignificance<-tapply(GeneSignificance, moduleColorsAutomatic, mean, na.rm=T);
  data.trait.GS[is.na(data.trait.GS)]=0;
  
  data.trait.GS.p<-vector();
  for (i in 1:length (colnames(data.t))){
    if(is.na(as.numeric(cor.test(data.t[,i],phenotype,use="p")$p.value))){
      data.trait.GS.p[i] =1;
    }else{
      data.trait.GS.p[i]=as.numeric(cor.test(data.t[,i],phenotype,use="p")$p.value) ;
    }
  };
  if (padjust){
    data.trait.GS.p<-p.adjust(data.trait.GS.p,method="bonferroni");
  }
  data.trait.GScolor=numbers2colors(as.numeric(data.trait.GS),colors=blueWhiteRed(100)) ;
  data.trait.p.GScolor=numbers2colors(as.numeric(data.trait.GS.p),colors=grey(seq(0,1,0.001))) ;
  if (plotPDF){
    pdf(file=paste(filename,"module.pdf",sep="."));
  }
  
  blocknumber=1 
  datColors=data.frame(moduleColorsAutomatic,data.trait.GScolor,data.trait.p.GScolor)[net$blockGenes[[blocknumber]],]
  plotDendroAndColors(net$dendrograms[[blocknumber]],colors=datColors, 
                      groupLabels=c("Module colors","JA correlation","p value"),dendroLabels=FALSE, 
                      hang=0.03,addGuide=TRUE,guideHang=0.05) ;
  if (plotPDF){
    dev.off();
    pdf(file=paste(filename,"module2trait.pdf",sep="."));
  }
  MEList=moduleEigengenes(data.t,colors=moduleColorsAutomatic) 
  MEs = MEList$eigengenes 
  # Add the weight to existing module eigengenes 
  MET=orderMEs(cbind(MEs,phenotype)) 
  # Plot the relationships among the eigengenes and the trait 
  plotEigengeneNetworks(MET,"",marDendro=c(0,4,1,2), 
                        marHeatmap=c(3,4,1,2),cex.lab=0.8,xLabelsAngle=90) ;
  if (plotPDF){
    dev.off();
  }
  ## ToM plot
  if (TOM ){
    A = adjacency(data.t, power = power, type="signed") 
    dissTOM<-TOMdist(A);
    diag(dissTOM) = NA;
    pdf(file=paste(filename,"Tomplot.pdf",sep="."));
    TOMplot(dissim=dissTOM^7, dendro=net$dendrograms[[blocknumber]],Colors=moduleColorsAutomatic, main = "Network heatmap plot") 
  }
  
  ## plot trait and module correlation:
  
  # Choose a module assignment 
  # Define numbers of genes and samples 
  nGenes = ncol(data.t) 
  nSamples = nrow(data.t) 
  # Recalculate MEs with color labels 
  MEs0 = moduleEigengenes(data.t,moduleColorsAutomatic)$eigengenes 
  MEsData = orderMEs(MEs0) 
  modTraitCor = cor(MEsData, phenotype, use = "p") 
  names(phenotype)<-"JA";
  modTraitP = corPvalueStudent(modTraitCor, nSamples) ;
  ME=signedKME(data.t, MEsData) 
  #Since we have a moderately large number of modules and traits, 
  #a suitable graphical representation will help in reading 
  #the table. We color code each association by the correlation value: 
  # Will display correlations and their p-values 
  textMatrix = paste(signif(modTraitCor, 2), "\n(", 
                     signif(modTraitP, 1), ")", sep = "") 
  dim(textMatrix) = dim(modTraitCor) 
  par(mar = c(6, 8.5, 3, 3)) 
  # Display the correlation values within a heatmap plot 
  labeledHeatmap(Matrix = modTraitCor, xLabels = names(phenotype), 
                 yLabels = names(MEsData), ySymbols = names(MEsData), 
                 colorLabels =FALSE,colors=greenWhiteRed(50),textMatrix=textMatrix, 
                 setStdMargins = FALSE, cex.text = 0.5, zlim = c(-1,1), 
                 main = paste("Module-trait relationships")) ;
  return(list(moduleColorsAutomatic,ME,moduleLabelsAutomatic.num,GeneSignificance));
}


Expression2Cytoscape<-function(data=NULL,FileName=NULL,threshold=0.01, attribute_ID=NULL,power=NULL, altNodeNames=NULL){
  data<-data;
  ## remove the constant values;
  data.var<-apply(data,1,sd);
  data<-data[!data.var==0,];
  if(is.null(power)){
    power=12;
  }
  if(is.null(altNodeNames)){
    altNodeNames=row.names(data)
  }
  #data<-data[,sapply(data, function(v) var(v, na.rm=TRUE)!=0)];
  TOMNat = TOMsimilarityFromExpr(t(data), power=13) ;
  if(is.null(attribute_ID)){
    attribute_ID<-rep("NA",nrow(data));
  }
  cyt = exportNetworkToCytoscape(TOMNat, edgeFile=paste(FileName,"CytoEdge",".txt",sep=""), 
                                 nodeFile=paste(FileName,"NatCytoNode",".txt",sep=""), 
                                 weighted = TRUE, threshold = threshold, nodeNames=row.names(data),
                                 altNodeNames = altNodeNames,nodeAttr =attribute_ID) ;
}


Expression2Heatmap<-function(data=NULL,fixcolor=F){
  data<-data
  cr = cor(data, method='spearman',use="pairwise.complete.obs");
  data = t(scale(t(data), scale=F));
  gene_dist = dist(data, method='euclidean');
  hc_genes = hclust(gene_dist, method='complete')
  hc_samples = hclust(as.dist(1-cr), method="complete") # cluster conditions
  myheatcol = greenred(75)
  gene_partition_assignments <- cutree(as.hclust(hc_genes), k=6);
  partition_colors = rainbow(length(unique(gene_partition_assignments)), start=0.4, end=0.95)
  gene_colors = partition_colors[gene_partition_assignments]
  gene_tree = hc2Newick(hc_genes);
  quantBrks = quantile(data, c(0.03, 0.97))
  if(fixcolor){
    return(heatmap.2(data, dendrogram='both', Rowv=as.dendrogram(hc_genes), Colv=FALSE, col=myheatcol, RowSideColors=gene_colors, scale="none", density.info="none", trace="none", key=TRUE, keysize=1.2, cexCol=1, lmat=rbind(c(5,0,4,0),c(3,1,2,0)), lhei=c(1.5,5),lwid=c(1.5,0.2,2.5,2.5), margins=c(12,5), breaks=seq(-1.5,1.5, length=76)))
  }else{
    return(heatmap.2(data, dendrogram='both', Rowv=as.dendrogram(hc_genes), Colv=as.dendrogram(hc_samples), col=myheatcol, RowSideColors=gene_colors, scale="none", density.info="none", trace="none", key=TRUE, keysize=1.2, cexCol=1, lmat=rbind(c(5,0,4,0),c(3,1,2,0)), lhei=c(1.5,5),lwid=c(1.5,0.2,2.5,2.5), margins=c(12,5), breaks=seq(quantBrks[1], quantBrks[2], length=76)))
  }
}

PlotGeneExpressionBar<-function(data=NULL,gene=NULL, species=NULL,ylim=NULL){
  require(ggplot2)
  data=data;
  gene=gene;
  species=species;
  sample.name.all<-colnames(data);
  sample.name.all<-sample.name.all[grep(species,sample.name.all)];
  sample.select<-sample.name.all[grep("WW|FAC",sample.name.all)];
  data.tmp<-data[gene,sample.select];
  data.tmp.t<-t(data.tmp);
  data.tmp.t<-as.numeric(as.character(data.tmp.t));
  Treatment<-gsub("\\d", "",sample.select)
  data.tmp.sub<-cbind(FPKM=data.tmp.t,Treatment=Treatment);
  data.tmp.sub<-data.frame(data.tmp.sub);
  data.tmp.sub$FPKM<-as.numeric(as.character(data.tmp.sub$FPKM));
  data.tmp.sub$Treatment<-factor(data.tmp.sub$Treatment,levels=rev(levels(data.tmp.sub$Treatment)),ordered=T)
  data.tmp.summary<-summarySE(data=data.tmp.sub,measurevar="FPKM",groupvars="Treatment");
  if(is.null(ylim)){
    ylim<-c(0,max(data.tmp.summary$mean+data.tmp.summary$se));
  }
  p<-ggplot(data.tmp.summary, aes(x=Treatment, y=mean, fill=Treatment)) + 
    geom_bar(position=position_dodge(width=0.1), stat="identity",width=0.2) +
    scale_fill_manual(values=c("grey","red"))+
    geom_errorbar(aes(ymin=mean-se, ymax=mean+se),
                  width=.0,                    # Width of the error bars
                  position=position_dodge(.9));
  p<-p+scale_y_continuous(limits=ylim,breaks=ylim) +
    theme(legend.position = "none");
  p<-p+theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
             panel.background = element_blank(), axis.line = element_line(colour = "black"))+
    theme(axis.ticks.x=element_blank())+
    ylab("TMM normalized FPKM");
  return (p);
}


Expression2Lineplot<-function(data=NULL,plot_lable=NULL,ylim=NULL){
  data = data;
  if(is.null(ylim)){
    ymin = min(data); ymax = max(data);
  }else{
    ymin = ylim[1]; ymax = ylim[2];
  }
  
  #  plot_label = paste(files[i], ', ', length(data[,1]), " trans", sep='')
  plot(as.numeric(data[1,]), type='l', ylim=c(ymin,ymax), main="", col='lightgray', xaxt='n', xlab='', ylab='Normalized Expression')
  axis(side=1, at=1:length(data[1,]), labels=colnames(data), las=2)
  for(r in 2:length(data[,1])) {
    points(as.numeric(data[r,]), type='l', col='lightgray');
  }
  points(as.numeric(colMeans(data)), type='o', col='blue');
}

pn <- function(X){crossprod(!is.na(X))}

cor.prob <- function(X){
  # Correlations Below Main Diagonal
  # Significance Tests with Pairwise Deletion
  # Above Main Diagonal
  # Believe part of this came from Bill Venables
  pair.SampSize <- pn(X)
  above1 <- row(pair.SampSize) < col(pair.SampSize)
  pair.df <- pair.SampSize[above1] - 2
  R <- cor(X, use="pair")
  above2 <- row(R) < col(R)
  r2 <- R[above2]^2
  Fstat <- (r2 * pair.df)/(1 - r2)
  R[above2] <- 1 - pf(Fstat, 1, pair.df)
  R
}
summarySE <- function(data=NULL, measurevar=NULL, groupvars=NULL, na.rm=FALSE,
                      conf.interval=.95, .drop=TRUE) {
  require(plyr)
  
  # New version of length which can handle NA's: if na.rm==T, don't count them
  length2 <- function (x, na.rm=FALSE) {
    if (na.rm) sum(!is.na(x))
    else       length(x)
  }
  
  # This is does the summary; it's not easy to understand...
  datac <- ddply(data, groupvars, .drop=.drop,
                 .fun= function(xx, col, na.rm) {
                   c( N    = length2(xx[,col], na.rm=na.rm),
                      mean = mean   (xx[,col], na.rm=na.rm),
                      var   = var     (xx[,col], na.rm=na.rm),
                      sd   = sd     (xx[,col], na.rm=na.rm)
                   )
                 },
                 measurevar,
                 na.rm
  )
  
  # Rename the "mean" column
  # datac <- rename(datac, c("mean"=measurevar))
  
  datac$se <- datac$sd / sqrt(datac$N)  # Calculate standard error of the mean
  
  # Confidence interval multiplier for standard error
  # Calculate t-statistic for confidence interval:
  # e.g., if conf.interval is .95, use .975 (above/below), and use df=N-1
  #  ciMult <- qt(conf.interval/2 + .5, datac$N-1)
  #  datac$ci <- datac$se * ciMult
  
  return(datac)
}


FILTER_EXPRESS<-function(group=NULL,data=NULL,number=NULL,cutoff=NULL){
  require (edgeR);
  ## select leaf specific genes;
  y.tmp <- DGEList(group=group, counts=data.frame(data));
  
  keep<-rowSums(y.tmp[[1]]>cutoff) >= number;
  
  y.tmp.keep <- y.tmp[keep,]
  data.out<-y.tmp.keep[[1]];
  return(data.out);
}


Data2SimilarityHeatmapHalf<-function(data=NULL, name.order=NULL){
  library(reshape2)
  # Get lower triangle of the correlation matrix
  get_lower_tri<-function(cormat){
    cormat[upper.tri(cormat)] <- NA
    return(cormat)
  }
  
  # Get upper triangle of the correlation matrix
  get_upper_tri <- function(cormat){
    cormat[lower.tri(cormat)]<- NA
    return(cormat)
  }
  data.cor<-cor(data);
  #melted_cormat <- melt( get_upper_tri(data.cor))
  melted_cormat<-melt(data.cor)
  #melted_cormat <- na.omit(melted_cormat)
  library(ggplot2)
  if(!is.na(name.order)){
    melted_cormat$Var1=factor(melted_cormat$Var1, levels=name.order,ordered=T)
    melted_cormat$Var2=factor(melted_cormat$Var2, levels=rev(name.order),ordered=T)
    
  }
  
  p<- ggplot(data = melted_cormat, aes(Var2, Var1, fill = value))+
    geom_tile(color = "white")+
    scale_fill_gradient2(low = "white", high = "red", mid="yellow",
                         midpoint = mean(melted_cormat$value), limit = c(min(melted_cormat$value),max(melted_cormat$value)), name="Pearson\nCorrelation") +
    theme_minimal()+ 
    theme(axis.text.x = element_text(angle = 45, vjust = 1, 
                                     size = 12, hjust = 1)) +
    scale_x_discrete(expand = c(.0, 0)) + 
    scale_y_discrete(expand = c(.0, 0)) 
  return(p);
  
}
Data2SimilarityHeatmap<-function(data=NULL){
  data=data;
  mat=cor(data,use="pairwise.complete.obs");
  ## plot heatmap
  heatmap.2(mat, col = 
              bluered(150),vline=F,hline=F,density.info="non",trace="none",dendrogram="row", 
            scale="none");
  
}


ExtractGeneExpression<-function(arraydata=NULL,probe2gene=NULL,gene.list=NULL){
  ## clean up data;
  data=data.frame(arraydata);
  gene.id<-probe2gene[row.names(gene.expression.all),1];  
  data=data[!is.na(gene.id),];
  gene.id=as.character(gene.id[!is.na(gene.id)]);
  ## only select subsect of the genes;     
  data.sub<-data[gene.id %in% gene.list,];
  genes=as.character(probe2gene[row.names(data.sub),1])
  ## if one gene has several different probles, only consider the highest expressed probe.
  MaxExpression <- aggregate(data.sub, list(genes), max);
  row.names(MaxExpression)<-MaxExpression[,1];
  MaxExpression<-MaxExpression[,-1]
  return(MaxExpression);
}


PlotPhytoData<-function(data=NULL){
  PhytoData.new<-data
  PhytoData.new.sub<-PhytoData.new[!PhytoData.new$Time==0,]
  FoldChange.matrix<-matrix(ncol=4,nrow=0);
  colnames(FoldChange.matrix)<-c("Species","Treatment","FoldChange","Relative")
  Species<-levels(PhytoData.new$Species);
  AverageM= function(df){
    molecular.sum<-sum(df[,3]);
    return(3*molecular.sum/nrow(df));
    
  }
  for(spe in Species){
    PhytoData.new.sub.sub<-PhytoData.new.sub[PhytoData.new.sub$Species==spe,c("Species","Treatment","JA")];
    AverageM.each<-ddply(PhytoData.new.sub.sub,.(Treatment),AverageM);
    colnames(AverageM.each)[2]="Concentration";
    FC<-log2(AverageM.each[,2]/AverageM.each[AverageM.each$Treatment=="WW",2]);
    concentration.scaled<-(AverageM.each[,2]-min(AverageM.each[,2]))/(max(AverageM.each[,2])-min(AverageM.each[,2]));
    FC.tmp<-cbind(Species=rep(spe,4),Treatment=levels(AverageM.each$Treatment),FoldChange=FC,Relative=concentration.scaled)
    FoldChange.matrix<-rbind(FoldChange.matrix,FC.tmp);
  }
  FoldChange.matrix<-data.frame(FoldChange.matrix);
  FoldChange.matrix$FoldChange<-as.numeric(as.character(FoldChange.matrix$FoldChange));
  FoldChange.matrix.sub<-FoldChange.matrix[grep("attenuata|miersii|obtusifolia|pauciflora",FoldChange.matrix$Species),];
  FoldChange.matrix.sub<-FoldChange.matrix.sub[!FoldChange.matrix.sub$Treatment=="WW",]
  FoldChange.matrix.sub$Species<-factor(FoldChange.matrix.sub$Species,levels=c("N_obtusifolia","N_attenuata","N_miersii","N_pauciflora"),ordered=T);
  FoldChange.matrix.sub$Relative<-as.numeric(as.character(FoldChange.matrix.sub$Relative))
  FoldChange.matrix.sub
  p<- ggplot(FoldChange.matrix.sub,aes(x=Species, y=Relative, fill=Treatment))+
    geom_bar(position=position_dodge(width=0.5), stat="identity",width=0.5)+
    scale_y_continuous(limits = c(0, 1.2))+
    theme(axis.ticks.x=element_blank())+
    theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
          panel.background = element_blank(), axis.line = element_line(colour = "black"))
  return (p);
}

Expression2Barplot<-function(data=NULL,GeneID=NULL,y.lim=NULL,y.lab=NULL, x.lab=NULL,GroupA=NULL,GroupB=NULL,orderA=NULL,orderB=NULL){
  require(ggplot2);
  if (is.null(GroupA)) {
    cat("Please provide group infomation\n");
    stop;
  }
  if (is.null(GroupB)) {
    cat("Please provide group infomation\n");
    stop;
  }
  data<-data[GeneID,];
  data.tmp.sub<-cbind(FPKM=as.numeric(data),Treatment=GroupA,Species=GroupB);
  data.tmp.sub<-data.frame(data.tmp.sub)
  if (!is.null(orderA)){
    data.tmp.sub$Treatment<-factor(data.tmp.sub$Treatment,levels=as.character(orderA),ordered=T)
  }
  if(!is.null(orderB)){
    data.tmp.sub$Species<-factor(data.tmp.sub$Species,levels=orderB,ordered=T)
  }
  data.tmp.sub$FPKM<-as.numeric(as.character(data.tmp.sub$FPKM));
  data.tmp.summary<-summarySE(data=data.tmp.sub,measurevar="FPKM",groupvars=c("Treatment","Species"));
  if(is.null(y.lim)){
    y.lim<-c(0,max(data.tmp.summary$mean+data.tmp.summary$se));
  }
  if (is.null(y.lab)){
    y.lab="TMM normalized log2(FPKM+1)";
    
  }
  if (is.null(x.lab)){
    y.lab="Species";
  }  
  p<-ggplot(data.tmp.summary, aes(x=Species, y=mean, fill=Treatment)) + 
    scale_fill_brewer()+
    geom_bar(position=position_dodge(0.6), stat="identity",width=0.5) +
    geom_errorbar(aes(ymin=mean-se, ymax=mean+se),
                  width=.0,                  # Width of the error bars
                  position=position_dodge(.6));
  p<-p+scale_y_continuous(limits=y.lim,breaks=y.lim) +
    theme(legend.position = "none");
  
  p<-p+theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), 
             panel.background = element_blank(), axis.line = element_line(colour = "black"))+
    theme(axis.ticks.x=element_blank())+
    ylab(y.lab)+
    xlab(x.lab);
  #  p<-p+facet_grid(Species ~ .) 
  p
  return (p);
}
