# Define the function to calculate likelihood under a certain model #
# P1: P( disease | +,D,C,C )
# P2: P( disease | +,D,T,C )
# P3: P( disease | +,D,T,T )
# P4: P( disease | +,+,C,C )
# P5: P( disease | +,+,T,C )
# P6: P( disease | +,+,T,T )
Lcal_family <- function(P1, P2, P3, P4, P5, P6){
    ###   Q78fs*41   ###
    L1 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6)
    ###   R345fs*194   ###
    L2 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*P3)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*(1-P5))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6)) 
    ###   A353fs*187   ###
    L3 = ((0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.25*(1-P2)*(1-P5))*P2)/((0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.125*(1-P2)*(1-P5))*P6 + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.25*(1-P2)*(1-P5))*P5 + (0.2*0.125*(1-P2)*(1-P5))*P4 + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.125*(1-P2)*(1-P5))*P3 + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.25*(1-P2)*(1-P5))*P2 + (0.2*0.125*(1-P2)*(1-P5))*P1) * 
        ((0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.125*(1-P2)*(1-P5))*(1-P3))/((0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.125*(1-P2)*(1-P5))*(1-P6) + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.25*(1-P2)*(1-P5))*(1-P5) + (0.2*0.125*(1-P2)*(1-P5))*(1-P4) + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.125*(1-P2)*(1-P5))*(1-P3) + (0.4*0.25*(1-P2)*(1-P6)+0.4*0.25*(1-P3)*(1-P5)+0.2*0.25*(1-P2)*(1-P5))*(1-P2) + (0.2*0.125*(1-P2)*(1-P5))*(1-P1)) * 
        (0.5*P2)/(0.5*P2 + 0.5*P5)    
    ###   R281fs*13   ###
    L4 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6)    
    ###   T306A   ###
    L5 = (0.5*(1-P3))/(0.5*(1-P3) + 0.5*(1-P6)) * (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*(1-P6))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6))    
    ###   S130fs*146   ###
    L6 = (0.5*P3)/(0.5*P3 + 0.5*P6)    
    ###   Q223*   ###
    L7 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*(1-P3))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6))   
    ###   P323L   ###
    L8 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6)   
    ###   E407*   ###
    L9 = (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6)   
    ###   R465C   ###
    L10 = ((0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*P2)/((0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*P2 + 0.3*0.25*(1-P2)*P1 + (0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*P5 + 0.3*0.25*(1-P2)*P4) * ((0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*(1-P5))/((0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*(1-P2) + 0.3*0.25*(1-P2)*(1-P1) + (0.3*0.25*(1-P2)+0.7*0.5*(1-P3))*(1-P5) + 0.3*0.25*(1-P2)*(1-P4))  
    ###   I490T   ###
    L11 = (0.25*(1-P3))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6)) * (0.25*(1-P6))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6)) * (0.25*P2)/(0.25*P2 + 0.25*P3 + 0.25*P5 + 0.25*P6) * (0.25*(1-P5))/(0.25*(1-P2) + 0.25*(1-P3) + 0.25*(1-P5) + 0.25*(1-P6))
    # Combine likelihood for all 11 informative families #
    Output = c(L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11)
    return(Output)    
}



###   LOD score by family   ###

# Two-locus vs. single-locus model #
Result = data.frame(Family=c("Q78fs*41","R345fs*194","A353fs*187","R281fs*13","T306A","S130fs*146","Q223*","P323L","E407*","R465C","I490T"),
                    LOD=log10(Lcal_family(1,1,0.09,0,0,0) / Lcal_family(0.2,0.2,0.2,0,0,0)))
Result
sum(Result[,2])   # This is your total LOD


# Two-locus vs. null model #
Result = data.frame(Family=c("Q78fs*41","R345fs*194","A353fs*187","R281fs*13","T306A","S130fs*146","Q223*","P323L","E407*","R465C","I490T"),
                    LOD=log10(Lcal_family(1,1,0.09,0,0,0) / Lcal_family(0.1,0.1,0.1,0.1,0.1,0.1)))
Result
sum(Result[,2])  


# Single-locus vs. null model #
Result = data.frame(Family=c("Q78fs*41","R345fs*194","A353fs*187","R281fs*13","T306A","S130fs*146","Q223*","P323L","E407*","R465C","I490T"),
                    LOD=log10(Lcal_family(0.2,0.2,0.2,0,0,0) / Lcal_family(0.1,0.1,0.1,0.1,0.1,0.1)))
Result
sum(Result[,2])  








