function [d] = dddist(pt1,pt2)
%This little function is built to calculate the distance between two points
%in 3d space.
%Synatax:   [d] = dddist(pt1,pt2);
%Input:     pt1 & pt2 = [x y z], an array of x, y and z coordinates.  Must
%               be of format [x;y;z], if only x y are provided z
%               is assumed to be 0.
%
%Output:    d = Is the vector of distances between pt1 and pt2.

%parse data & error check
if size(pt1)~=size(pt2)
    error('The arrays of vertcies you entered are not the same size.')
end
%make sure there is coordinates for z third column
if size(pt1,2)==2   %add z if necessary
    pt_tmp = zeros(size(pt1,1),1);
    pt1 = horzcat(pt1(:,1:2),pt_tmp);
    pt2 = horzcat(pt2(:,1:2),pt_tmp);
elseif size(pt1,2)~=3   %only 3 columns, 
    error('The points must be presented in a x by 6 array, with xyz in a row.')
end

%Calculate the distance
d_mat = abs(pt2-pt1);           %First convert from pixel position to x y z distance.
d = hypot(hypot(d_mat(:,1),d_mat(:,2)),d_mat(:,3));     %create distance vector
