function [mfreq] = max_freq(data)
%This function helps the user calculate the value that occur most
%frequently.  This is essentially the mode, but sometimes the mode function
%does not return the proper mode for AT data, because of the nature of the
%data structure.
%Synatax:   [data] = max_freq(); 
%Input:     data = the input scalar data, the max frequency is calculated
%                  along columns, if there are multiple columns the max
%                  frequency of occurance will be calculated for all values
%                  of all columns
%Output:    mfreq = a 1 by x vector cell where each column is the value 
%               that occured most often in that column of data.  If there
%               are multiple maxs, those values will be presented as a
%               column vector

%preallocate
mfreq = cell(1,size(data,2));
for i = 1:size(data,2)      %step through columns
    col_tmp = data(:,i);    %pull one column to play with
    col_tmp = sort(col_tmp);    %sort the column first so all like values are bunched
    col_idx = collapse(col_tmp,1);  %collapse down the column into an index of the values in the column
    bins = hist(col_tmp,size(col_idx,1));   %use the hist function to determin the frequency of each value that appears in the col
    %the location of the max bin is the location of the max value in col_idx
    mfreq{i} = col_idx(bins==max(bins));            %set the value
end