function verify = struct_check(struct,check_str)
%This verifies whether the structure entered has the fields specified in
%check_str.
%Syntax: verify = struct_check(structure,{'field1','field2'...});
%Input: struct = the structure to be verified
%       check_str = a cell array of field strings, which this function will use
%       to verify the structure' fields.  Note the check string should be a
%       vertical cell vector
%Output: verify = 1 if all fields check out, a cell array of fields if
%           there are errors.

%Initialize
verify = [];     %verified
err = 0;        %no errors

%check if the structure have all of the strings in check_str
%the fields of the structure first
struct_str = fieldnames(struct);

%now verify the strings
h = waitbar(0,'Field (...) Processed...');    %initialize progress bar.
for i = 1:size(check_str,1);
    index = 1;
    while 1
        if strcmp(struct_str{index,1},check_str{i,1})
            break       %found a match, go to next
        elseif index>=size(struct_str,1)     %no match, store the error
            err = err+1;
            verify{1,err} = check_str{i,1};
            break
        else
            index = index+1;
        end
    end
    waitbar(i/size(check_str,1),h,['Field (',check_str{i,1},') Processed...']);   %show progress
end
if isempty(verify)  %No errors
    verify = 1;     %no erros
end
close(h);   %close progress bar