function vector = vectorize(array,varargin)
%A little function to convert arrays into one long vector.
%Syntax: vector = vectorize(array);
%Input: array = Any array that needs to be made into a vector.
%       dim = The dimension of the vectorization. 1(default) = compresses
%       along the columns, producing one long column vector. 2 = compresses
%       along the rows, producing one long row vector.
%Output: vector = The output vector.

a = size(array);        %Get the size of the incoming array

if isempty(varargin)    %Assign the Dim value
    dim = 1;
else
    dim = varargin{1,1};
end

vector = [];    %Initialize the vector

switch dim
    case 1      %Create a column vector
        for i = 1:a(1,2)
            vector = [vector;array(:,i)];
        end
    case 2      %Create a row vector
        for i = 1:a(1,1)
            vector = [vector array(i,:)];
        end
    otherwise
        Error(['You entered a dimension beyond our comprehension']);
end