function [] = mvdir(dir_tmp,out_tmp,copyroot)
%Move directory and all subdirectories and files
%Synatax:   [] = mvdir(dir_tmp,out_tmp,copyroot);
%Input:     dir_tmp = the directory of interest
%           out_tmp = the location of the cloned directory structure
%           copyroot = copy over the root or just copy over the content of
%           the root. 0 or 1, default 1 (copy root).  To just use copy root
%           use syntax: mvdir([],[],0);
%Output:    no output at this moment

%where are the files?
if nargin<3
    copyroot = 1;
end
if nargin<2||isempty(dir_tmp)
    dir_tmp = uigetdir2('','Directory structure you want to move');    %get the directory
    out_tmp = uigetdir3('','Where do you want to go?');
end
%localization for macs (Replaced by filesep)
% if ispc
%     slash = '\';        %Windows directory marker
% else
%     slash = '/';        %Mac directory marker
% end

%copy over the root first
if copyroot
    idx = find(dir_tmp==filesep);   %find the location of every file seperator
    dir_name = dir_tmp(idx(end)+1:end);     %grab the name of the directory
    mkdir(out_tmp,dir_name);    %make new the directory
    out_tmp = [out_tmp,filesep,dir_name];   %new out directory
end
root_name = dir_tmp;    %set aside for later

%lets process the root
dir_root = dir(dir_tmp);  %grab the root
idx = [dir_root.isdir];   %grab all of the isdir numbers - the first two
idx(1:2) = 0;
curr_names = {dir_root.name};   %grab the all of the names in the root
dir_list = curr_names(idx);    %the directory names in root
%move the files in root if there are any
file_list = curr_names(~[dir_root.isdir]);     %only the filenames are taken
if ~isempty(file_list)
    mvfiles(dir_tmp,out_tmp,file_list);
end

if ~isempty(dir_list)   %if the root only have files, then no need to go further
    out_tmp = repmat([out_tmp filesep],size(dir_list'));    %replicated the out_put name for appending
    out_list = horzcat(cellstr(out_tmp),dir_list');      %now each cell contains the full output directory path
    dir_tmp = repmat([dir_tmp filesep],size(dir_list'));    %replicated the directory name for appending
    dir_list = cellstr([dir_tmp char(dir_list')]);      %now each cell contains the full directory path
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        out_tmp = [];
        dir_end = 0;    %reset
        %level in
        for i = 1:size(dir_list,1)  %for each dir_step down one
            mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
            curr_dir = dir_list{i};     %current directory
            dir_info = dir(dir_list{i}); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            idx(1:2) = 0;   %toss the first two
            curr_names = {dir_info.name};   %grab the all of the names
            dir_nxt = curr_names(idx);    %the directories
            %grab the filenames if there are any
            file_list = curr_names(~[dir_info.isdir]);     %only the filenames are taken
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
                %move all of the files in this directory
                mvfiles(curr_dir,curr_out,file_list);
            else    %not the bottom
                %if there are files move them
                if ~isempty(file_list)
                    mvfiles(curr_dir,curr_out,file_list);
                end
                %now prep for the next cycle
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
            end
        end
        if dir_end==size(dir_list,1)    %all directories are at an end
            break
        else    %move next level down
            dir_list = dir_tmp;
            out_list = out_tmp;
        end
    end
end
%now remove the directory and the subdirectories
rmdir(root_name,'s');

%--------------------------------------------------------------------------
function [] = mvfiles(dir_tmp,out_tmp,file_list)
%Move all of the files from one directory to another
for i = 1:size(file_list,2);
    movefile([dir_tmp,filesep,file_list{i}],out_tmp);
end