function output_vector = randomize(input_vector)
%A little function that takes a vector and then returns a randomized column
%vector of the numbers in the input vector.
%Syntax: output_vector = randomize(input_vector);
%Input: input_vector = a vector of numbers that need to be randomized.
%Output:    output_vector = the randomized output of the input_vector.

if size(input_vector,2)>1       %The input is a row vector
    input_vector = input_vector';   %Transpose the input vector'
end

index = rand(1,size(input_vector,1));       %Generate a random vector the same size as the input_vector
x = rand(1,size(input_vector,1));           %A second random vector is generated
index = index.*x;                           %The 2 vectors are combined to decrease the probability of repeat values in the vector

y = [index' input_vector];                  %Combine the index with the input_vector
z = sortrows(y);                            %Sort according to the random index to randomize the input_vector

output_vector = z(:,2);                     %Output the randomized vector