function s_DefineGCs_v4(si,Ch,SIv)
% directory. reading the previously registered stacks
if strcmp(Ch,'G')
    regDir = si.regG; 
else
    regDir = si.regR;   
end
regList  = dir(cat(2,regDir,'*.tif'));
seedIdx = SIv.seedIdx;
info = imfinfo([regDir regList(seedIdx).name]);
sizX = info.Width; sizY = info.Height; sizZ = numel(info);
zFirst = 1; zLast = sizZ; zLength = zLast-zFirst+1; % throwback to earlier version. may clean up later.
disp('reading seed stack...');
inStkH = TIFFStack([regDir regList(seedIdx).name]);
seedStk = single(squeeze(inStkH(:,:,:,1)));
delete(inStkH);
disp('background subtraction...');
mskStkG03 = imgaussian(seedStk,3);
mskStkG10 = imgaussian(seedStk,10);
mskStkNet = single(uint16(mskStkG03-mskStkG10)); % background subtracted stack
clear mskStkG03 mskStkG10
disp('...done.');
disp('opening the background subtracted stack...');
eLeg = round(1.2/SIv.xyRes); eDim = 2*eLeg+1;
eBox = zeros(eDim,eDim,eDim); eBox(eLeg+1,eLeg+1,eLeg+1) = 1;
eBox = bwdist(eBox)<eLeg+1;
oStk = imopen(mskStkNet,eBox);
disp('...done.');

disp('reading ShieldMask...');
inStkH = TIFFStack([si.img 'ShieldMask.tif']);
shieldMsk = single(squeeze(inStkH(:,:,:,1)));
delete(inStkH);
distMsk = bwdist(shieldMsk);
distShell = distMsk<15;

disp('masking regional maxima with opened and segmented stack...');
mxMsk0 = imregionalmax(mskStkNet);
mxMsk = ((oStk.*distShell).*mxMsk0)>0;

% test = min((distShell.*seedStk)+(~distShell),[],3);

% regional max are not all single pixel in size. using the centroids to
% reduce them in size
ctrStrct = regionprops(bwconncomp(mxMsk),'centroid');
ctrSubs = zeros(length(ctrStrct),3);
for i0 = 1:length(ctrStrct); ctrSubs(i0,:) = round(ctrStrct(i0).Centroid); end

objX = ctrSubs(:,1);
objY = ctrSubs(:,2);
objZ = ctrSubs(:,3);

disp('building and saving gridfit shield mask.');
mskLims = [2.5 -2.5];
density = 2;%5; 
[zg,xg,yg] = sint_gritfitExt(round([objX objY objZ]),[sizX sizY sizZ],density);
figure, plot3( objX, objY, objZ, '.r' );
axis equal
hold on;
p = surf(xg,yg,zg);
set( p, 'FaceColor', 'g','FaceAlpha',0.5 );

XI = 1:0.5:sizX; YI = 1:0.5:sizY; % create finer mesh and interpolate the gridfit.
[Xm,Ym] = meshgrid(XI,YI);
Zm = interp2(xg,yg,zg,Xm,Ym);
truZ = find(ge(round(Zm(:)),1) & le(round(Zm(:)),sizZ)); % reigning in the extended z dimension from gridfit
Km = unique(sub2ind([sizY sizX sizZ],round(Ym(truZ)),round(Xm(truZ)),round(Zm(truZ))));
shield = zeros(sizY,sizX,sizZ,'int8');
shield(Km) = 1;

disp('creating directional distance map...');
dirMsk = ones(sizY,sizX,sizZ,'int8'); 
[Kr,Kc,Kz] = ind2sub([sizY sizX sizZ],Km);
for j1 = 1:numel(Km)
    z1 = max(Kz(j1));
    dirMsk(Kr(j1),Kc(j1),z1:end) = -1;
end
distX = bwdist(shield);
distX = distX.*single(dirMsk);

disp('applying shell limits...');
ShieldMask = le(distX,mskLims(1)) & ge(distX,mskLims(2));


fileName = [si.img 'CompShieldMask.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
for t0 = 1:size(ShieldMask,3)
    imwrite(uint8(ShieldMask(:,:,t0)),fileName,...
                                     'tiff','Compression','none','WriteMode','append');
end

disp('watershed segmentation...');
mskWSPools = zeros(size(mskStkNet));
matlabpool open 6
tic
parfor i0 = 1:sizZ
    mskWShed = watershed(-mskStkNet(:,:,i0));
    kWMskShed = mskWShed==0;
    mskWSSlc = ones(size(mskWShed));
    mskWSSlc(kWMskShed) = 0; % watershed regions.
    mskWSSlc = imclearborder(mskWSSlc);
    mskWSSlc = bwmorph(mskWSSlc,'erode',3);
    mskWSPools(:,:,i0) = mskWSSlc;
end
toc
matlabpool close
disp('...done.');
disp('masking the watershed segmented stack with the composite shield.');
mskStkRegs = (mskStkNet & mskWSPools).*logical(ShieldMask);
clear mskWSPools 

% extract the area and pixel index statistics for the regions.
disp('labeling the seed mask...');
[regMaskL, numRegs] = bwlabeln(mskStkRegs);
statsRegs = regionprops(regMaskL, 'Area','PixelIdxList');
clear regMaskL
regArea = zeros(numRegs,1);
regPrct = zeros(numRegs,3);
for i0 = 1:numRegs
    regArea(i0) = statsRegs(i0).Area;
    kPix = statsRegs(i0).PixelIdxList;
    regPrct(i0,:) = prctile(mskStkNet(kPix),[25 75 95]);
end
[~,Kmsk_regArea] = kmeans_oa_v(regArea,1:numRegs,100);
kA = find(Kmsk_regArea>1); % remove very small regions

% the problem addressed here is the significant drop in signal intensity
% through the stack. the approach is to break up the regions identified
% as the intersection of the background subtracted seed Stk and the
% watershed regions into classes of similar intensity. k-means based
% thresholding is then applied to each class separately.
numClass = 7; % user defined value. empirical.
disp(['separating labeled regions into ',num2str(numClass),' classes based on 95th percentile intensity values...']); 
[~,Kmsk_regPrct] = kmeans_oa_v(round(regPrct(kA,3)),1:numel(kA),numClass); % breaking up the regions into numClass classes by 95th percentile value.
kStk = zeros(sizY,sizX,sizZ,'single');
for i0 = 1:numClass
    cK = find(Kmsk_regPrct==i0);
    allPix = [];
    for i1 = 1:numel(cK)
        onPix = statsRegs(kA(cK(i1))).PixelIdxList;
        allPix = [allPix; onPix];
    end
    [~,kmStk] = kmeans_oa_v(mskStkNet(allPix),1:numel(allPix),4);
    kStk(allPix(kmStk>1))=1;
end
[kStkMip,kStkIdx] = max(kStk,[],3);
%figure, imshow(kStkMip,[]);
% clean up kStk with regional maxima from the mip to remove regions without
% maxima
disp('removing regions without local maxima...');
[rPeak,cPeak] = find(kStkMip.*imregionalmax(max(mskStkNet,[],3)));
idxPeak2d = sub2ind(size(kStkMip),rPeak,cPeak);
zPeak = kStkIdx(idxPeak2d);
idxPeak = sub2ind(size(kStk),rPeak,cPeak,zPeak);
kStkCC = bwconncomp(kStk);
kStkL = labelmatrix(kStkCC);
regmaxL = unique(kStkL(idxPeak)); regmaxL(regmaxL==0) = []; % last command removes background pixels in set, if any.
kStk = zeros(size(kStk));
nanStk=NaN(size(kStk)); % the Nan stak is used to break-up or delineate two objects that overlap in 3D but project to appear as one in 3D.
for i0 = 1:length(regmaxL)
    ind = kStkCC.PixelIdxList{regmaxL(i0)};
    kStk(ind) = i0;
    nanStk(ind) = i0;
end
kStkMip = max(kStk,[],3);
nanStkMip = min(nanStk,[],3); % min call ignores nan entries, which means that the minimum projection can be other than pure black.
kStkMip(abs(nanStkMip-kStkMip)>0) = 0;
% older versions of these outputs will be automatically overwritten
disp('writing segmented seed mask mip.');
imwrite(uint16(max(seedStk.*logical(ShieldMask(:,:,zFirst:zLast)),[],3)),[si.img 'seedStkMip.tif'],'tiff','Compression','none');
imwrite(uint16(logical(kStkMip)),[si.img 'seedMskMip.tif'],'tiff','Compression','none');
%%
% interrupt further processing while user fixes the seedMskMip
while exist([si.img 'seedMskMip_fx.tif'],'file') == 0
    disp('waiting for fixed seed mask...');
    pause(60)
end
disp('received fixed seed mask, moving on...');

kStkMipFx = single(imread([si.img 'seedMskMip_fx.tif'],'tiff'));
kStkFx = repmat(kStkMipFx-kStkMip,[1 1 zLength]); % user added pixels are +1, deleted pixels are -1.
kStk = ((kStk+kStkFx) > 0).*logical(ShieldMask(:,:,zFirst:zLast));

disp('   labeling seed mask,');
[gcMaskL, numGC] = bwlabeln(kStk);
statsGC = regionprops(gcMaskL, 'Area','PixelIdxList','PixelList');
gcKlas = ones(numGC,2); gcKlas(:,1) = 1:numGC; % GC classifier variable.
% 1: processed through, -1: border crossers, -2: smaller than k-means set volume threshold,
% -3: far from fit spherical surface, -4: line masks are out of bounds.
disp('   identifying border crossers,');
mipGCmaskL = max(gcMaskL,[],3);
kBrdrX = setdiff(unique(abs(mipGCmaskL-imclearborder(mipGCmaskL))),0);
gcKlas(kBrdrX,2) = -1; % marking border crossers

gcVol = zeros(numGC,1); % number of pixels in each labeled object
gcMaxPix = zeros(numGC,3); % maximum valued pixel (x,y,z) of each GC in background subtracted stack mipStkNet.
for i2 = 1:numGC
    if gcKlas(i2,2) ~= -1; % skip border crossers
        gcVol(i2) = statsGC(i2).Area;
        idxList = statsGC(i2).PixelIdxList;
        [~,idxMax] = max(mskStkNet(idxList));
        gcMaxPix(i2,:) = statsGC(i2).PixelList(idxMax,:);
    end
end
kPass = find(gcKlas(:,2)==1); % the index of surviving GCs

% eventhough we performed a size threshold above, the manual clean-up does
% warrant a second pass through such a filter.
[mu,kmVol] = kmeans_oa_v(gcVol,kPass,20);
kVolSml = find(kmVol == 1);
gcKlas(kPass(kVolSml),2) = -2; % marking GCs below volume threshold
kPass = find(gcKlas(:,2)==1); % the index of surviving GCs

% fitting the surviving GC maxima to a sphere and filtering outliers.

disp('   filtering outliers with sphere fit,');
c1 = gcMaxPix(kPass,1);
r1 = gcMaxPix(kPass,2);
z1 = gcMaxPix(kPass,3);
[ ~, radii, ~, v ] = ellipsoid_fit([c1 r1 z1],3); % sphere fit to surviving GC set 
%suite_plotEllfit(c1,r1,z1,center,radii,v);
[k0,ctr1,rad1,v1,counter] = s_filtSphfit(c1,r1,z1,radii,v,0.02);
suite_plotEllfit(c1(k0),r1(k0),z1(k0),ctr1,rad1,v1);

gcKlas(kPass(setdiff(1:numel(kPass),k0)),2) = -3; % marking GCs far from fit spherical surface
kPass = find(gcKlas(:,2)==1); % the index of surviving GCs

vData = [gcMaxPix(kPass,1) gcMaxPix(kPass,2) gcMaxPix(kPass,3)];
disp('fitting a new surface to the surviving GCs');
density = 2; %5; 
[zg,xg,yg] = sint_gritfitExt(round([vData(:,1) vData(:,2) vData(:,3)]),[sizX sizY sizZ],density);
figure, plot3( vData(:,1), vData(:,2), vData(:,3), '.r' );
axis equal
hold on;
p = surf(xg,yg,zg);
set( p, 'FaceColor', 'g','FaceAlpha',0.5 );

XI = 1:10:sizX; YI = 1:10:sizY; % create finer mesh and interpolate the gridfit.
[Xm,Ym] = meshgrid(XI,YI);
Zm = interp2(xg,yg,zg,Xm,Ym);
truZ = find(ge(round(Zm(:)),1) & le(round(Zm(:)),sizZ)); % reigning in the extended z dimension from gridfit

vField = [round(Xm(truZ)) round(Ym(truZ)) round(Zm(truZ))];


dimData = size(vData,1);
dimField = size(vField,1);
[mX,mY] = meshgrid(1:dimData,1:dimField);
dMat = reshape(sqrt(sum((vField(mY,:)-vData(mX,:)).^2,2)),dimField,dimData);
[sMat,iS] = sort(dMat,1);

disp('estimating extension vector using local curvature,');
% X1 = gcMaxPix(kPass,:)';
% M1 = slmetric_pw(X1, X1, 'eucdist'); % pairwise distance matrix
% [~,idxM] = sort(M1); 

unitGC = zeros(3,numel(kPass));
centGC = zeros(3,numel(kPass));
locR = round(10/SIv.xyRes); % neighborhood radius for local vector estimation
for i2 = 1:numel(kPass)
    
    kLoc = find(le(sMat(:,i2),locR));
    xyzLoc = vField(iS(kLoc,i2),:);
    n = fitNormal(xyzLoc,0);
    n = sign(n(3))*n;

    unitGC(:,i2) = n;
    centGC(:,i2) = vData(i2,:)';
    
end

figure, quiver3(centGC(1,:),centGC(2,:),centGC(3,:),unitGC(1,:),unitGC(2,:),unitGC(3,:));
axis equal


zShift = zeros(3,numel(kPass));
zShift(3,:) = zFirst-1;
Y = centGC + zShift; % bringing the centGC coordinates back to the original stack dimensions
c2 = Y(1,:)'; r2 = Y(2,:)'; z2 = Y(3,:)';
[ center, radii, ~, v ] = ellipsoid_fit([c2 r2 z2],3); % sphere fit to final GC set 
suite_plotEllfit(c2,r2,z2,center,radii,v);

% reordering the GCs: Y:left2right, X:top2bottom
kS = sub2ind([sizX sizY],c2,r2); % to use the built-in ordering of sub2ind, switch the dimensions of r and c. 
[~,iS] = sort(kS);
Y = Y(:,iS);
unitGC = unitGC(:,iS);

disp('   building line mask along the extension vector,');
lineSpans = cell(numel(kPass), 1);
% building the line masks to extend 10 um above and 20 um below the growth
% cone intensity maxima.
lineTop = 10; lineBot = 20; % internal variables that can be changed as needed.
rad1 = lineTop/SIv.xyRes;
rad2 = lineBot/SIv.xyRes;
for i5 = 1:numel(kPass)
    truIdx = i5;
    iX = Y(1,truIdx) - rad1*unitGC(1,truIdx); iY = Y(2,truIdx) - rad1*unitGC(2,truIdx); iZ = Y(3,truIdx) - rad1*unitGC(3,truIdx);
    fX = Y(1,truIdx) + rad2*unitGC(1,truIdx); fY = Y(2,truIdx) + rad2*unitGC(2,truIdx); fZ = Y(3,truIdx) + rad2*unitGC(3,truIdx);
    spanX = round(linspace(iX,fX,10*rad2)); spanY = round(linspace(iY,fY,10*rad2)); spanZ = round(linspace(iZ,fZ,10*rad2));
    kLine = find(ge(spanX,1).*ge(spanY,1).*ge(spanZ,1).*le(spanX,sizX).*le(spanY,sizY).*le(spanZ,sizZ));
    spanIdx = sub2ind([sizY, sizX, sizZ],spanY(kLine),spanX(kLine),spanZ(kLine));
    lineSpans{i5,1} = spanIdx;
end

% constructing gcMask and lineMask marked with final GC ids.
lineMask = zeros([sizY, sizX, sizZ],'uint16');
gcMask = zeros([sizY, sizX, zLength],'uint16');
for i6 = 1:numel(kPass)
    lineMask(lineSpans{i6,1}) = i6;
    gcMask(statsGC(kPass(iS(i6))).PixelIdxList) = i6; 
end
%figure, imshow(max(lineMask,[],3),[]);
zShift = zeros(size(centGC));
zShift(3,:) = zFirst-1;
centGC = centGC + zShift; % bringing the centGC coordinates back to the original stack dimensions
centGC = centGC(:,iS);

% cleanup and identification complete. saving output variables.
disp('GC identification complete. writing files...');
fileName = [si.img 'gcMask.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
gcMaskFull = zeros([sizY, sizX, sizZ],'double');
gcMaskFull(:,:,zFirst:zLast) = gcMask;
for i1 = 1:sizZ
    imwrite(uint16(gcMaskFull(:,:,i1)),fileName,...
        'tiff','Compression','none','WriteMode','append');
end
fileName = [si.img 'LineMask.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
for i1 = 1:sizZ
    imwrite(uint16(lineMask(:,:,i1)),fileName,...
        'tiff','Compression','none','WriteMode','append');
end
% that's it. write the sphere fit variables, centGC coordinates, and the unitGCs.
dlmwrite([si.txt 'gcSphereFit.txt'], [center' radii' v], '\t');
dlmwrite([si.txt 'SeedGCs.txt'],centGC,'\t');
dlmwrite([si.txt 'UnitGCs.txt'],unitGC,'\t');
disp('done.');

